/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.hetu.core.transport.block.BlockSerdeUtil;
import io.hetu.core.transport.execution.buffer.GenericPagesSerde;
import io.hetu.core.transport.execution.buffer.PageCodecMarker;
import io.hetu.core.transport.execution.buffer.PagesSerde;
import io.hetu.core.transport.execution.buffer.SerializedPage;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;

public class PagesSerdeUtil {
    public static final int DEFAULT_NUM_PAGES_PREFETCH = 1;

    private PagesSerdeUtil() {
    }

    static void writeRawPage(Kryo kryo, Page page, Output output, Serializer serde) {
        output.write(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(kryo, serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(Kryo kryo, int positionCount, Input input, Serializer blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(kryo, blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    static Page readRawPage(int positionCount, Properties pageMetadata, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, pageMetadata, blocks);
    }

    public static void writeSerializedPage(SliceOutput output, SerializedPage page) {
        output.writeInt(page.getPositionCount());
        output.writeByte((int)page.getPageCodecMarkers());
        output.writeInt(page.getUncompressedSizeInBytes());
        output.writeInt(page.getSizeInBytes());
        output.writeBytes(page.getSlice());
        if (page.getPageMetadata().size() != 0) {
            String pageProperties = page.getPageMetadata().toString();
            byte[] propertiesByte = pageProperties.replaceAll(",", System.lineSeparator()).substring(1, pageProperties.length() - 1).getBytes(StandardCharsets.UTF_8);
            output.writeInt(propertiesByte.length);
            output.writeBytes(propertiesByte);
        } else {
            output.writeInt(0);
        }
    }

    public static SerializedPage readSerializedPage(Slice slice) {
        int offset = 0;
        int positionCount = slice.getInt(offset);
        PageCodecMarker.MarkerSet markers = PageCodecMarker.MarkerSet.fromByteValue(slice.getByte(offset += 4));
        int uncompressedSizeInBytes = slice.getInt(++offset);
        int sizeInBytes = slice.getInt(offset += 4);
        Slice sliceData = slice.slice(offset += 4, Math.toIntExact(sizeInBytes));
        int propertiesLength = slice.getInt(offset += Math.toIntExact(sizeInBytes));
        if (propertiesLength != 0) {
            byte[] pageMetadataBytes = new byte[propertiesLength];
            slice.getBytes(offset += 4, propertiesLength);
            Properties pros = new Properties();
            try {
                pros.load(new ByteArrayInputStream(pageMetadataBytes));
                return new SerializedPage(sliceData, markers, positionCount, uncompressedSizeInBytes, pros);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new SerializedPage(sliceData, markers, positionCount, uncompressedSizeInBytes);
    }

    private static SerializedPage readSerializedPage(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        PageCodecMarker.MarkerSet markers = PageCodecMarker.MarkerSet.fromByteValue(sliceInput.readByte());
        int uncompressedSizeInBytes = sliceInput.readInt();
        int sizeInBytes = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(Math.toIntExact(sizeInBytes));
        int propertiesLength = sliceInput.readInt();
        if (propertiesLength != 0) {
            byte[] pageMetadataBytes = new byte[propertiesLength];
            sliceInput.readBytes(pageMetadataBytes);
            Properties pros = new Properties();
            try {
                pros.load(new ByteArrayInputStream(pageMetadataBytes));
                return new SerializedPage(slice, markers, positionCount, uncompressedSizeInBytes, pros);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new SerializedPage(slice, markers, positionCount, uncompressedSizeInBytes);
    }

    public static long writeSerializedPages(SliceOutput sliceOutput, Iterable<SerializedPage> pages) {
        Iterator<SerializedPage> pageIterator = pages.iterator();
        long size = 0L;
        while (pageIterator.hasNext()) {
            SerializedPage page = pageIterator.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, page);
            size += (long)page.getSizeInBytes();
        }
        return size;
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        while (pages.hasNext()) {
            Page page = pages.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, serde.serialize(page));
            size += page.getSizeInBytes();
        }
        return size;
    }

    public static Iterator<Page> readPages(GenericPagesSerde serde, SliceInput sliceInput, int spillPrefetchReadPages) {
        return new PageReader(serde, sliceInput, spillPrefetchReadPages);
    }

    public static Iterator<Page> readPages(GenericPagesSerde serde, SliceInput sliceInput) {
        return new PageReader(serde, sliceInput);
    }

    public static Iterator<Page> readPages(GenericPagesSerde serde, SliceInput sliceInput, int spillPrefetchReadPages, Predicate<InputStream> eof) {
        return new PageReader(serde, sliceInput, spillPrefetchReadPages, eof);
    }

    public static Iterator<Page> readPagesDirect(GenericPagesSerde serde, InputStream input, Predicate<InputStream> eof, int spillPrefetchReadPages) {
        return new PageReaderDirect(serde, input, eof, spillPrefetchReadPages);
    }

    public static Iterator<SerializedPage> readSerializedPages(SliceInput sliceInput) {
        return new SerializedPageReader(sliceInput);
    }

    private static class SerializedPageReader
    extends AbstractIterator<SerializedPage> {
        private final SliceInput input;

        SerializedPageReader(SliceInput input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        protected SerializedPage computeNext() {
            if (!this.input.isReadable()) {
                return (SerializedPage)this.endOfData();
            }
            return PagesSerdeUtil.readSerializedPage(this.input);
        }
    }

    private static class PageReaderDirect
    extends AbstractIterator<Page> {
        private final GenericPagesSerde serde;
        private final InputStream input;
        private final Predicate<InputStream> eof;
        private final int spillPrefetchReadPages;
        LinkedList<Page> prefetchedPages;

        PageReaderDirect(GenericPagesSerde serde, InputStream input, Predicate<InputStream> eof) {
            this(serde, input, eof, 1);
        }

        PageReaderDirect(GenericPagesSerde serde, InputStream input, Predicate<InputStream> eof, int spillPrefetchReadPages) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.eof = Objects.requireNonNull(eof, "End of data needs to passed");
            Preconditions.checkArgument((spillPrefetchReadPages > 0 ? 1 : 0) != 0, (Object)"spillPrefetchReadPages cannot be less then 1");
            this.prefetchedPages = new LinkedList();
            this.spillPrefetchReadPages = spillPrefetchReadPages;
        }

        protected Page computeNext() {
            if (this.eof.test(this.input) && this.prefetchedPages.size() == 0) {
                return (Page)this.endOfData();
            }
            if (this.prefetchedPages.size() == 0) {
                for (int i = 0; i < this.spillPrefetchReadPages && !this.eof.test(this.input); ++i) {
                    this.prefetchedPages.add(this.serde.deserialize(this.input));
                }
            }
            return this.prefetchedPages.removeFirst();
        }
    }

    private static class PageReader
    extends AbstractIterator<Page> {
        private final GenericPagesSerde serde;
        private final SliceInput input;
        private final int spillPrefetchReadPages;
        Predicate<InputStream> eof;
        LinkedList<Page> prefetchedPages;

        PageReader(GenericPagesSerde serde, SliceInput input) {
            this(serde, input, 1, null);
        }

        PageReader(GenericPagesSerde serde, SliceInput sliceInput, int spillPrefetchReadPages) {
            this(serde, sliceInput, spillPrefetchReadPages, null);
        }

        PageReader(GenericPagesSerde serde, SliceInput input, int spillPrefetchReadPages, Predicate<InputStream> eof) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
            Preconditions.checkArgument((spillPrefetchReadPages > 0 ? 1 : 0) != 0, (Object)"spillPrefetchReadPages cannot be less then 1");
            this.prefetchedPages = new LinkedList();
            this.spillPrefetchReadPages = spillPrefetchReadPages;
            this.eof = eof;
        }

        protected Page computeNext() {
            if (this.eof != null ? this.eof.test((InputStream)this.input) && this.prefetchedPages.size() == 0 : !this.input.isReadable() && this.prefetchedPages.size() == 0) {
                return (Page)this.endOfData();
            }
            if (this.prefetchedPages.size() == 0) {
                for (int i = 0; i < this.spillPrefetchReadPages && (this.eof != null ? !this.eof.test((InputStream)this.input) : this.input.isReadable()); ++i) {
                    this.prefetchedPages.add(this.serde.deserialize(PagesSerdeUtil.readSerializedPage(this.input)));
                }
            }
            return this.prefetchedPages.removeFirst();
        }
    }
}

