/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.airlift.slice.Slices;
import io.hetu.core.transport.execution.buffer.PageCodecMarker;
import io.hetu.core.transport.execution.buffer.SerializedPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class SerializedPageSerde {
    private static final Serializer<SerializedPage> serializer = new Serializer<SerializedPage>(){

        public void write(Kryo kryo, Output output, SerializedPage page) {
            output.writeInt(page.getPositionCount());
            output.writeByte(page.getPageCodecMarkers());
            output.writeInt(page.getUncompressedSizeInBytes());
            output.writeInt(page.getSizeInBytes());
            output.writeBytes(page.getSliceArray());
            if (page.getPageMetadata().size() != 0) {
                String pageProperties = page.getPageMetadata().toString();
                byte[] propertiesByte = pageProperties.replaceAll(",", System.lineSeparator()).substring(1, pageProperties.length() - 1).getBytes(StandardCharsets.UTF_8);
                output.writeInt(propertiesByte.length);
                output.writeBytes(propertiesByte);
            } else {
                output.writeInt(0);
            }
        }

        public SerializedPage read(Kryo kryo, Input input, Class<? extends SerializedPage> type) {
            int positionCount = input.readInt();
            byte pageCodecMarkers = input.readByte();
            int uncompressedSizeInBytes = input.readInt();
            int sliceLength = input.readInt();
            byte[] sliceBytes = input.readBytes(sliceLength);
            int pageMetadataBytesLength = input.readInt();
            if (pageMetadataBytesLength > 0) {
                byte[] pageMetadataBytes = input.readBytes(pageMetadataBytesLength);
                Properties pageMetadata = new Properties();
                try {
                    pageMetadata.load(new ByteArrayInputStream(pageMetadataBytes));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return new SerializedPage(Slices.wrappedBuffer((byte[])sliceBytes), PageCodecMarker.MarkerSet.fromByteValue(pageCodecMarkers), positionCount, uncompressedSizeInBytes, pageMetadata);
            }
            return new SerializedPage(sliceBytes, pageCodecMarkers, positionCount, uncompressedSizeInBytes);
        }
    };

    private SerializedPageSerde() {
    }

    public static void serialize(OutputStream output, SerializedPage page) {
        serializer.write(null, (Output)output, (Object)page);
    }

    public static SerializedPage deserialize(InputStream input) {
        return (SerializedPage)serializer.read(null, (Input)input, SerializedPage.class);
    }

    public static void serialize(Kryo kryo, OutputStream output, SerializedPage page) {
        serializer.write(kryo, (Output)output, (Object)page);
    }

    public static SerializedPage deserialize(Kryo kryo, InputStream input) {
        return (SerializedPage)serializer.read(kryo, (Input)input, SerializedPage.class);
    }
}

