/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidType;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private final String dimension;
    private final ExtractionFunction extractionFunction;
    private final String outputName;
    private final DruidType outputType;

    public ExtractionDimensionSpec(String dimension, ExtractionFunction extractionFunction, String outputName) {
        this(dimension, extractionFunction, outputName, DruidType.STRING);
    }

    public ExtractionDimensionSpec(String dimension, ExtractionFunction extractionFunction, String outputName, DruidType outputType) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension);
        this.extractionFunction = (ExtractionFunction)Preconditions.checkNotNull((Object)extractionFunction);
        this.outputName = outputName;
        this.outputType = outputType == null ? DruidType.STRING : outputType;
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public DruidType getOutputType() {
        return this.outputType;
    }

    @Override
    public ExtractionFunction getExtractionFn() {
        return this.extractionFunction;
    }

    @Override
    public String getDimension() {
        return this.dimension;
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "extraction");
        generator.writeStringField("dimension", this.dimension);
        DruidQuery.writeFieldIf(generator, "outputName", this.outputName);
        DruidQuery.writeField(generator, "extractionFn", this.extractionFunction);
        generator.writeEndObject();
    }

    @Nullable
    public static Granularity toQueryGranularity(DimensionSpec dimensionSpec) {
        if (!"__time".equals(dimensionSpec.getDimension())) {
            return null;
        }
        ExtractionFunction extractionFunction = dimensionSpec.getExtractionFn();
        if (extractionFunction == null) {
            return null;
        }
        if (extractionFunction instanceof TimeExtractionFunction) {
            Granularity granularity = ((TimeExtractionFunction)extractionFunction).getGranularity();
            String format = ((TimeExtractionFunction)extractionFunction).getFormat();
            if (!"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".equals(format)) {
                return null;
            }
            return granularity;
        }
        return null;
    }
}

