/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.parquet.DictionaryPage;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSourceId;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.dictionary.Dictionary;
import io.prestosql.parquet.predicate.DictionaryDescriptor;
import io.prestosql.parquet.predicate.ParquetDoubleStatistics;
import io.prestosql.parquet.predicate.ParquetIntegerStatistics;
import io.prestosql.parquet.predicate.ParquetRangeStatistics;
import io.prestosql.parquet.predicate.ParquetStringStatistics;
import io.prestosql.parquet.predicate.Predicate;
import io.prestosql.parquet.predicate.PredicateUtils;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.Varchars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;

public class TupleDomainParquetPredicate
implements Predicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<RichColumnDescriptor> columns;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<RichColumnDescriptor> columns) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    @Override
    public boolean matches(long numberOfRows, Map<ColumnDescriptor, Statistics<?>> statistics, ParquetDataSourceId id, boolean failOnCorruptedParquetStatistics) throws ParquetCorruptionException {
        if (numberOfRows == 0L) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            Statistics<?> columnStatistics;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || (columnStatistics = statistics.get((Object)column)) == null || columnStatistics.isEmpty() || effectivePredicateDomain.overlaps(domain = TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), numberOfRows, columnStatistics, id, column.toString(), failOnCorruptedParquetStatistics))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(DictionaryDescriptor dictionary) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(dictionary.getColumnDescriptor());
        return effectivePredicateDomain == null || TupleDomainParquetPredicate.effectivePredicateMatches(effectivePredicateDomain, dictionary);
    }

    private static boolean effectivePredicateMatches(Domain effectivePredicateDomain, DictionaryDescriptor dictionary) {
        return effectivePredicateDomain.overlaps(TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), dictionary));
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, Statistics<?> statistics, ParquetDataSourceId id, String column, boolean failOnCorruptedParquetStatistics) throws ParquetCorruptionException {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = statistics.getNumNulls() != 0L;
        if (statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        if (type.equals(BooleanType.BOOLEAN) && statistics instanceof BooleanStatistics) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
            boolean hasTrueValues = booleanStatistics.getMax() || booleanStatistics.getMin();
            boolean bl2 = hasFalseValues = !booleanStatistics.getMax() || !booleanStatistics.getMin();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            throw new VerifyException("Impossible boolean statistics");
        }
        if ((type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) && (statistics instanceof LongStatistics || statistics instanceof IntStatistics)) {
            ParquetIntegerStatistics parquetIntegerStatistics;
            if (statistics instanceof LongStatistics) {
                LongStatistics longStatistics = (LongStatistics)statistics;
                if (longStatistics.genericGetMin() > longStatistics.genericGetMax()) {
                    TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, longStatistics);
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                parquetIntegerStatistics = new ParquetIntegerStatistics(longStatistics.genericGetMin(), longStatistics.genericGetMax());
            } else {
                IntStatistics intStatistics = (IntStatistics)statistics;
                if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                    TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, intStatistics);
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                parquetIntegerStatistics = new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax()));
            }
            if (PredicateUtils.isStatisticsOverflow(type, parquetIntegerStatistics)) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics);
        }
        if (type.equals(RealType.REAL) && statistics instanceof FloatStatistics) {
            FloatStatistics floatStatistics = (FloatStatistics)statistics;
            if (floatStatistics.genericGetMin().floatValue() > floatStatistics.genericGetMax().floatValue()) {
                TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, floatStatistics);
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetIntegerStatistics parquetStatistics = new ParquetIntegerStatistics(Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMin())), Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMax())));
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStatistics);
        }
        if (type.equals(DoubleType.DOUBLE) && statistics instanceof DoubleStatistics) {
            DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
            if (doubleStatistics.genericGetMin() > doubleStatistics.genericGetMax()) {
                TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, doubleStatistics);
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetDoubleStatistics parquetDoubleStatistics = new ParquetDoubleStatistics(doubleStatistics.genericGetMin(), doubleStatistics.genericGetMax());
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetDoubleStatistics);
        }
        if (Varchars.isVarcharType((Type)type) && statistics instanceof BinaryStatistics) {
            Slice maxSlice;
            BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
            Slice minSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMin().getBytes());
            if (minSlice.compareTo(maxSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMax().getBytes())) > 0) {
                TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, binaryStatistics);
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetStringStatistics parquetStringStatistics = new ParquetStringStatistics(minSlice, maxSlice);
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStringStatistics);
        }
        if (type.equals(DateType.DATE) && statistics instanceof IntStatistics) {
            IntStatistics intStatistics = (IntStatistics)statistics;
            if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                TupleDomainParquetPredicate.failWithCorruptionException(failOnCorruptedParquetStatistics, column, id, intStatistics);
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            ParquetIntegerStatistics parquetIntegerStatistics = new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax()));
            return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return Domain.all((Type)type);
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<DictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (!dictionaryPage.isPresent()) {
            return Domain.all((Type)type);
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return Domain.all((Type)type);
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToLong(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if ((type.equals(BigintType.BIGINT) || type.equals(DateType.DATE)) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToInt(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.DOUBLE) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToDouble(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.FLOAT) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToFloat(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (Varchars.isVarcharType((Type)type) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)Slices.wrappedBuffer((byte[])dictionary.decodeToBinary(i).getBytes())));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        return Domain.all((Type)type);
    }

    private static void failWithCorruptionException(boolean failOnCorruptedParquetStatistics, String column, ParquetDataSourceId id, Statistics<?> statistics) throws ParquetCorruptionException {
        if (failOnCorruptedParquetStatistics) {
            throw new ParquetCorruptionException(String.format("Corrupted statistics for column \"%s\" in Parquet file \"%s\": [%s]", column, id, statistics));
        }
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<T> rangeStatistics) {
        return TupleDomainParquetPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }
}

