/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.Varchars;
import org.apache.parquet.io.api.Binary;

public class BinaryColumnReader
extends PrimitiveColumnReader {
    public BinaryColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            Slice value = binary.length() == 0 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])binary.getBytes());
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            if (Chars.isCharType((Type)type)) {
                value = Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
            }
            type.writeSlice(blockBuilder, value);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

