/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.RetryPolicy;

public class NoRetryPolicy
implements RetryPolicy {
    private int retryCount = 0;
    private int waitInterval = 100;

    @Override
    public boolean shouldRetry(int httpResponseCode, Exception lastException) {
        if (httpResponseCode == 401 && this.retryCount == 0) {
            this.wait(this.waitInterval);
            ++this.retryCount;
            return true;
        }
        return false;
    }

    private void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

