/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TableOperationType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

final class MimePart {
    int httpStatusCode = -1;
    String httpStatusMessage;
    HashMap<String, String> headers = new HashMap();
    String payload;
    TableOperationType op;
    URI requestIdentity;

    MimePart() {
    }

    String toRequestString() {
        StringBuilder builder = new StringBuilder();
        MimePart.appendHeader(builder);
        builder.append(String.format("%s %s HTTP/1.1\r\n", MimePart.getHttpVerbForOperation(this.op), this.requestIdentity.toString()));
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            builder.append(String.format("%s: %s\r\n", header.getKey(), header.getValue()));
        }
        builder.append("\r\n");
        if (this.payload != null) {
            builder.append(this.payload);
        }
        return builder.toString();
    }

    static void appendHeader(StringBuilder builder) {
        builder.append("Content-Type: application/http\r\n");
        builder.append("Content-Transfer-Encoding: binary\r\n\r\n");
    }

    static String getHttpVerbForOperation(TableOperationType operationType) {
        if (operationType == TableOperationType.INSERT) {
            return "POST";
        }
        if (operationType == TableOperationType.DELETE) {
            return "DELETE";
        }
        if (operationType == TableOperationType.MERGE || operationType == TableOperationType.INSERT_OR_MERGE) {
            return "MERGE";
        }
        if (operationType == TableOperationType.REPLACE || operationType == TableOperationType.INSERT_OR_REPLACE) {
            return "PUT";
        }
        if (operationType == TableOperationType.RETRIEVE) {
            return "GET";
        }
        throw new IllegalArgumentException("Unknown table operation.");
    }
}

