/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.EdmType;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TableEntity;
import java.util.Date;
import java.util.Formatter;
import java.util.UUID;

public class TableQuery<T extends TableEntity> {
    private Class<T> clazzType = null;
    private String sourceTableName = null;
    private String[] columns = null;
    private Integer takeCount;
    private String filterString = null;

    public static <T extends TableEntity> TableQuery<T> from(Class<T> clazzType) {
        return new TableQuery<T>(clazzType);
    }

    public static String generateFilterCondition(String propertyName, String operation, boolean value) {
        return TableQuery.generateFilterCondition(propertyName, operation, value ? "true" : "false", EdmType.BOOLEAN);
    }

    public static String generateFilterCondition(String propertyName, String operation, byte[] value) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        for (byte b : value) {
            formatter.format("%02x", b);
        }
        formatter.flush();
        formatter.close();
        return TableQuery.generateFilterCondition(propertyName, operation, sb.toString(), EdmType.BINARY);
    }

    public static String generateFilterCondition(String propertyName, String operation, Byte[] value) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        Byte[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte b = arr$[i$];
            formatter.format("%02x", b);
        }
        formatter.flush();
        formatter.close();
        return TableQuery.generateFilterCondition(propertyName, operation, sb.toString(), EdmType.BINARY);
    }

    public static String generateFilterCondition(String propertyName, String operation, Date value) {
        return TableQuery.generateFilterCondition(propertyName, operation, Utility.getJavaISO8601Time(value), EdmType.DATE_TIME);
    }

    public static String generateFilterCondition(String propertyName, String operation, double value) {
        return TableQuery.generateFilterCondition(propertyName, operation, Double.toString(value), EdmType.DOUBLE);
    }

    public static String generateFilterCondition(String propertyName, String operation, int value) {
        return TableQuery.generateFilterCondition(propertyName, operation, Integer.toString(value), EdmType.INT32);
    }

    public static String generateFilterCondition(String propertyName, String operation, long value) {
        return TableQuery.generateFilterCondition(propertyName, operation, Long.toString(value), EdmType.INT64);
    }

    public static String generateFilterCondition(String propertyName, String operation, String value) {
        return TableQuery.generateFilterCondition(propertyName, operation, value, EdmType.STRING);
    }

    public static String generateFilterCondition(String propertyName, String operation, String value, EdmType edmType) {
        String valueOperand = null;
        valueOperand = edmType == EdmType.BOOLEAN || edmType == EdmType.DOUBLE || edmType == EdmType.INT32 ? value : (edmType == EdmType.INT64 ? String.format("%sL", value) : (edmType == EdmType.DATE_TIME ? String.format("datetime'%s'", value) : (edmType == EdmType.GUID ? String.format("guid'%s'", value) : (edmType == EdmType.BINARY ? String.format("X'%s'", value) : String.format("'%s'", value.replace("'", "''"))))));
        return String.format("%s %s %s", propertyName, operation, valueOperand);
    }

    public static String generateFilterCondition(String propertyName, String operation, UUID value) {
        return TableQuery.generateFilterCondition(propertyName, operation, value.toString(), EdmType.GUID);
    }

    public static String combineFilters(String filterA, String operator, String filterB) {
        return String.format("(%s) %s (%s)", filterA, operator, filterB);
    }

    public TableQuery() {
    }

    public TableQuery(Class<T> clazzType) {
        this.setClazzType(clazzType);
    }

    public Class<T> getClazzType() {
        return this.clazzType;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String getFilterString() {
        return this.filterString;
    }

    protected String getSourceTableName() {
        return this.sourceTableName;
    }

    public Integer getTakeCount() {
        return this.takeCount;
    }

    public TableQuery<T> select(String[] columns) {
        this.setColumns(columns);
        return this;
    }

    public void setClazzType(Class<T> clazzType) {
        Utility.assertNotNull("class type", clazzType);
        Utility.checkNullaryCtor(clazzType);
        this.clazzType = clazzType;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public void setFilterString(String filterString) {
        Utility.assertNotNullOrEmpty("filterString", filterString);
        this.filterString = filterString;
    }

    protected void setSourceTableName(String sourceTableName) {
        Utility.assertNotNullOrEmpty("tableName", sourceTableName);
        this.sourceTableName = sourceTableName;
    }

    public void setTakeCount(Integer takeCount) {
        if (takeCount != null && takeCount <= 0) {
            throw new IllegalArgumentException("Take count must be positive and greater than 0.");
        }
        this.takeCount = takeCount;
    }

    public TableQuery<T> take(Integer take) {
        if (take != null) {
            this.setTakeCount(take);
        }
        return this;
    }

    public TableQuery<T> where(String filter) {
        this.setFilterString(filter);
        return this;
    }

    protected UriQueryBuilder generateQueryBuilder() throws StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        if (!Utility.isNullOrEmpty(this.filterString)) {
            builder.add("$filter", this.filterString);
        }
        if (this.takeCount != null) {
            builder.add("$top", this.takeCount.toString());
        }
        if (this.columns != null && this.columns.length > 0) {
            StringBuilder colBuilder = new StringBuilder();
            boolean foundRk = false;
            boolean foundPk = false;
            boolean roundTs = false;
            for (int m = 0; m < this.columns.length; ++m) {
                if ("RowKey".equals(this.columns[m])) {
                    foundRk = true;
                } else if ("PartitionKey".equals(this.columns[m])) {
                    foundPk = true;
                } else if ("Timestamp".equals(this.columns[m])) {
                    roundTs = true;
                }
                colBuilder.append(this.columns[m]);
                if (m >= this.columns.length - 1) continue;
                colBuilder.append(",");
            }
            if (!foundPk) {
                colBuilder.append(",");
                colBuilder.append("PartitionKey");
            }
            if (!foundRk) {
                colBuilder.append(",");
                colBuilder.append("RowKey");
            }
            if (!roundTs) {
                colBuilder.append(",");
                colBuilder.append("Timestamp");
            }
            builder.add("$select", colBuilder.toString());
        }
        return builder;
    }

    public static class QueryComparisons {
        public static final String EQUAL = "eq";
        public static final String NOT_EQUAL = "ne";
        public static final String GREATER_THAN = "gt";
        public static final String GREATER_THAN_OR_EQUAL = "ge";
        public static final String LESS_THAN = "lt";
        public static final String LESS_THAN_OR_EQUAL = "le";
    }

    public static class Operators {
        public static final String AND = "and";
        public static final String NOT = "not";
        public static final String OR = "or";
    }
}

