/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http;

import io.prestosql.hadoop.$internal.com.squareup.okhttp.Address;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.ConnectionPool;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.Route;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.Internal;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.RouteDatabase;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.Util;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.Http1xStream;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.Http2xStream;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.HttpStream;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.RetryableSink;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.RouteException;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.http.RouteSelector;
import io.prestosql.hadoop.$internal.com.squareup.okhttp.internal.io.RealConnection;
import io.prestosql.hadoop.$internal.okio.Sink;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class StreamAllocation {
    public final Address address;
    private final ConnectionPool connectionPool;
    private RouteSelector routeSelector;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpStream stream;

    public StreamAllocation(ConnectionPool connectionPool, Address address) {
        this.connectionPool = connectionPool;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpStream newStream(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws RouteException, IOException {
        try {
            HttpStream resultStream;
            RealConnection resultConnection = this.findHealthyConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled, doExtensiveHealthChecks);
            if (resultConnection.framedConnection != null) {
                resultStream = new Http2xStream(this, resultConnection.framedConnection);
            } else {
                resultConnection.getSocket().setSoTimeout(readTimeout);
                resultConnection.source.timeout().timeout(readTimeout, TimeUnit.MILLISECONDS);
                resultConnection.sink.timeout().timeout(writeTimeout, TimeUnit.MILLISECONDS);
                resultStream = new Http1xStream(this, resultConnection.source, resultConnection.sink);
            }
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                ++resultConnection.streamCount;
                this.stream = resultStream;
                return resultStream;
            }
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException, RouteException {
        while (true) {
            RealConnection candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (candidate.streamCount == 0) {
                    return candidate;
                }
            }
            if (candidate.isHealthy(doExtensiveHealthChecks)) {
                return candidate;
            }
            this.connectionFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled) throws IOException, RouteException {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.stream != null) {
                throw new IllegalStateException("stream != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            RealConnection allocatedConnection = this.connection;
            if (allocatedConnection != null && !allocatedConnection.noNewStreams) {
                return allocatedConnection;
            }
            RealConnection pooledConnection = Internal.instance.get(this.connectionPool, this.address, this);
            if (pooledConnection != null) {
                this.connection = pooledConnection;
                return pooledConnection;
            }
            if (this.routeSelector == null) {
                this.routeSelector = new RouteSelector(this.address, this.routeDatabase());
            }
        }
        Route route = this.routeSelector.next();
        RealConnection newConnection = new RealConnection(route);
        this.acquire(newConnection);
        ConnectionPool connectionPool2 = this.connectionPool;
        synchronized (connectionPool2) {
            Internal.instance.put(this.connectionPool, newConnection);
            this.connection = newConnection;
            if (this.canceled) {
                throw new IOException("Canceled");
            }
        }
        newConnection.connect(connectTimeout, readTimeout, writeTimeout, this.address.getConnectionSpecs(), connectionRetryEnabled);
        this.routeDatabase().connected(newConnection.getRoute());
        return newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(HttpStream stream) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (stream == null || stream != this.stream) {
                throw new IllegalStateException("expected " + this.stream + " but was " + stream);
            }
        }
        this.deallocate(false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpStream stream() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.stream;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public synchronized RealConnection connection() {
        return this.connection;
    }

    public void release() {
        this.deallocate(false, true, false);
    }

    public void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate(boolean noNewStreams, boolean released, boolean streamFinished) {
        RealConnection connectionToClose = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (streamFinished) {
                this.stream = null;
            }
            if (released) {
                this.released = true;
            }
            if (this.connection != null) {
                if (noNewStreams) {
                    this.connection.noNewStreams = true;
                }
                if (this.stream == null && (this.released || this.connection.noNewStreams)) {
                    this.release(this.connection);
                    if (this.connection.streamCount > 0) {
                        this.routeSelector = null;
                    }
                    if (this.connection.allocations.isEmpty()) {
                        this.connection.idleAtNanos = System.nanoTime();
                        if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                            connectionToClose = this.connection;
                        }
                    }
                    this.connection = null;
                }
            }
        }
        if (connectionToClose != null) {
            Util.closeQuietly(connectionToClose.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection connectionToCancel;
        HttpStream streamToCancel;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            streamToCancel = this.stream;
            connectionToCancel = this.connection;
        }
        if (streamToCancel != null) {
            streamToCancel.cancel();
        } else if (connectionToCancel != null) {
            connectionToCancel.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionFailed(IOException e) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.routeSelector != null) {
                if (this.connection.streamCount == 0) {
                    Route failedRoute = this.connection.getRoute();
                    this.routeSelector.connectFailed(failedRoute, e);
                } else {
                    this.routeSelector = null;
                }
            }
        }
        this.connectionFailed();
    }

    public void connectionFailed() {
        this.deallocate(true, false, true);
    }

    public void acquire(RealConnection connection) {
        connection.allocations.add(new WeakReference<StreamAllocation>(this));
    }

    private void release(RealConnection connection) {
        int size = connection.allocations.size();
        for (int i = 0; i < size; ++i) {
            Reference<StreamAllocation> reference = connection.allocations.get(i);
            if (reference.get() != this) continue;
            connection.allocations.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public boolean recover(RouteException e) {
        if (this.connection != null) {
            this.connectionFailed(e.getLastConnectException());
        }
        return (this.routeSelector == null || this.routeSelector.hasNext()) && this.isRecoverable(e);
    }

    public boolean recover(IOException e, Sink requestBodyOut) {
        boolean canRetryRequestBody;
        if (this.connection != null) {
            int streamCount = this.connection.streamCount;
            this.connectionFailed(e);
            if (streamCount == 1) {
                return false;
            }
        }
        boolean bl = canRetryRequestBody = requestBodyOut == null || requestBodyOut instanceof RetryableSink;
        return (this.routeSelector == null || this.routeSelector.hasNext()) && this.isRecoverable(e) && canRetryRequestBody;
    }

    private boolean isRecoverable(IOException e) {
        if (e instanceof ProtocolException) {
            return false;
        }
        return !(e instanceof InterruptedIOException);
    }

    private boolean isRecoverable(RouteException e) {
        IOException ioe = e.getLastConnectException();
        if (ioe instanceof ProtocolException) {
            return false;
        }
        if (ioe instanceof InterruptedIOException) {
            return ioe instanceof SocketTimeoutException;
        }
        if (ioe instanceof SSLHandshakeException && ioe.getCause() instanceof CertificateException) {
            return false;
        }
        return !(ioe instanceof SSLPeerUnverifiedException);
    }

    public String toString() {
        return this.address.toString();
    }
}

