/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2Entry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbError;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.MethodData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class KrbHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KrbHandler.class);
    private PreauthHandler preauthHandler;

    public void init(KrbContext context) {
        this.preauthHandler = new PreauthHandler();
        this.preauthHandler.init(context);
    }

    public void handleRequest(KdcRequest kdcRequest, boolean tryNextKdc) throws KrbException {
        ByteBuffer requestMessage;
        if (!tryNextKdc || kdcRequest.getKdcReq() == null) {
            kdcRequest.process();
        }
        KdcReq kdcReq = kdcRequest.getKdcReq();
        int bodyLen = kdcReq.encodingLength();
        KrbTransport transport = (KrbTransport)kdcRequest.getSessionData();
        boolean isTcp = transport.isTcp();
        if (!isTcp) {
            requestMessage = ByteBuffer.allocate(bodyLen);
        } else {
            requestMessage = ByteBuffer.allocate(bodyLen + 4);
            requestMessage.putInt(bodyLen);
        }
        KrbCodec.encode(kdcReq, requestMessage);
        requestMessage.flip();
        try {
            this.sendMessage(kdcRequest, requestMessage);
        }
        catch (IOException e) {
            throw new KrbException("sending message failed", (Throwable)e);
        }
    }

    public void onResponseMessage(KdcRequest kdcRequest, ByteBuffer responseMessage) throws KrbException {
        KrbMessage kdcRep = null;
        try {
            kdcRep = KrbCodec.decodeMessage(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("Krb decoding message failed", (Throwable)e);
        }
        KrbMessageType messageType = kdcRep.getMsgType();
        if (messageType == KrbMessageType.AS_REP) {
            kdcRequest.processResponse((KdcRep)kdcRep);
        } else if (messageType == KrbMessageType.TGS_REP) {
            kdcRequest.processResponse((KdcRep)kdcRep);
        } else if (messageType == KrbMessageType.KRB_ERROR) {
            KrbError error = (KrbError)kdcRep;
            LOG.info("KDC server response with message: " + error.getErrorCode().getMessage());
            if (error.getErrorCode() == KrbErrorCode.KDC_ERR_PREAUTH_REQUIRED) {
                MethodData methodData = KrbCodec.decode(error.getEdata(), MethodData.class);
                List paDataEntryList = methodData.getElements();
                ArrayList<EncryptionType> encryptionTypes = new ArrayList<EncryptionType>();
                for (PaDataEntry paDataEntry : paDataEntryList) {
                    if (paDataEntry.getPaDataType() != PaDataType.ETYPE_INFO2) continue;
                    EtypeInfo2 etypeInfo2 = KrbCodec.decode(paDataEntry.getPaDataValue(), EtypeInfo2.class);
                    List info2Entries = etypeInfo2.getElements();
                    for (EtypeInfo2Entry info2Entry : info2Entries) {
                        encryptionTypes.add(info2Entry.getEtype());
                    }
                }
                kdcRequest.setEncryptionTypes(encryptionTypes);
                kdcRequest.setPreauthRequired(true);
                kdcRequest.resetPrequthContxt();
                this.handleRequest(kdcRequest, false);
                LOG.info("Retry with the new kdc request including pre-authentication.");
            } else {
                LOG.info(error.getErrorCode().getMessage());
                throw new KrbException(error.getErrorCode(), error.getEtext());
            }
        }
    }

    protected abstract void sendMessage(KdcRequest var1, ByteBuffer var2) throws IOException;
}

