/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;

public final class CustomTokenProviderAdapter
extends AccessTokenProvider {
    private CustomTokenProviderAdaptee adaptee;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public CustomTokenProviderAdapter(CustomTokenProviderAdaptee adaptee) {
        Preconditions.checkNotNull(adaptee, "adaptee");
        this.adaptee = adaptee;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing custom based token");
        AzureADToken azureADToken = new AzureADToken();
        azureADToken.setAccessToken(this.adaptee.getAccessToken());
        azureADToken.setExpiry(this.adaptee.getExpiryTime());
        return azureADToken;
    }
}

