/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import io.prestosql.hadoop.$internal.com.google.protobuf.InvalidProtocolBufferException;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.fusesource.leveldbjni.JniDBFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class InMemoryAliasMap
implements InMemoryAliasMapProtocol,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAliasMap.class);
    private final .DB levelDb;
    private Configuration conf;
    private String blockPoolID;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    static String createPathErrorMessage(String directory) {
        return "Configured directory '" + directory + "' doesn't exist";
    }

    @Nonnull
    public static InMemoryAliasMap init(Configuration conf, String blockPoolID) throws IOException {
        .Options options = new .Options();
        options.createIfMissing(true);
        String directory = conf.get("dfs.provided.aliasmap.inmemory.leveldb.dir");
        LOG.info("Attempting to load InMemoryAliasMap from \"{}\"", (Object)directory);
        File levelDBpath = blockPoolID != null ? new File(directory, blockPoolID) : new File(directory);
        if (!levelDBpath.exists()) {
            String error = InMemoryAliasMap.createPathErrorMessage(directory);
            throw new IOException(error);
        }
        .DB levelDb = JniDBFactory.factory.open(levelDBpath, options);
        InMemoryAliasMap aliasMap = new InMemoryAliasMap(levelDb, blockPoolID);
        aliasMap.setConf(conf);
        return aliasMap;
    }

    @VisibleForTesting
    InMemoryAliasMap(.DB levelDb, String blockPoolID) {
        this.levelDb = levelDb;
        this.blockPoolID = blockPoolID;
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        try (.DBIterator iterator = this.levelDb.iterator();){
            Integer batchSize = this.conf.getInt("dfs.provided.aliasmap.inmemory.batch-size", 500);
            if (marker.isPresent()) {
                iterator.seek(InMemoryAliasMap.toProtoBufBytes(marker.get()));
            } else {
                iterator.seekToFirst();
            }
            ArrayList<FileRegion> batch = Lists.newArrayListWithExpectedSize(batchSize);
            for (int i = 0; iterator.hasNext() && i < batchSize; ++i) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Block block = InMemoryAliasMap.fromBlockBytes((byte[])entry.getKey());
                ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes((byte[])entry.getValue());
                batch.add(new FileRegion(block, providedStorageLocation));
            }
            if (iterator.hasNext()) {
                Block nextMarker = InMemoryAliasMap.fromBlockBytes((byte[])((Map.Entry)iterator.next()).getKey());
                InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.of(nextMarker));
                return iterationResult;
            }
            InMemoryAliasMapProtocol.IterationResult iterationResult = new InMemoryAliasMapProtocol.IterationResult(batch, Optional.empty());
            return iterationResult;
        }
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = this.levelDb.get(extendedBlockDbFormat);
        if (providedStorageLocationDbFormat == null) {
            return Optional.empty();
        }
        ProvidedStorageLocation providedStorageLocation = InMemoryAliasMap.fromProvidedStorageLocationBytes(providedStorageLocationDbFormat);
        return Optional.of(providedStorageLocation);
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        byte[] extendedBlockDbFormat = InMemoryAliasMap.toProtoBufBytes(block);
        byte[] providedStorageLocationDbFormat = InMemoryAliasMap.toProtoBufBytes(providedStorageLocation);
        this.levelDb.put(extendedBlockDbFormat, providedStorageLocationDbFormat);
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolID;
    }

    public void close() throws IOException {
        this.levelDb.close();
    }

    @Nonnull
    public static ProvidedStorageLocation fromProvidedStorageLocationBytes(@Nonnull byte[] providedStorageLocationDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = HdfsProtos.ProvidedStorageLocationProto.parseFrom(providedStorageLocationDbFormat);
        return PBHelperClient.convert(providedStorageLocationProto);
    }

    @Nonnull
    public static Block fromBlockBytes(@Nonnull byte[] blockDbFormat) throws InvalidProtocolBufferException {
        HdfsProtos.BlockProto blockProto = HdfsProtos.BlockProto.parseFrom(blockDbFormat);
        return PBHelperClient.convert(blockProto);
    }

    public static byte[] toProtoBufBytes(@Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = PBHelperClient.convert(providedStorageLocation);
        ByteArrayOutputStream providedStorageLocationOutputStream = new ByteArrayOutputStream();
        providedStorageLocationProto.writeTo(providedStorageLocationOutputStream);
        return providedStorageLocationOutputStream.toByteArray();
    }

    public static byte[] toProtoBufBytes(@Nonnull Block block) throws IOException {
        HdfsProtos.BlockProto blockProto = PBHelperClient.convert(block);
        ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
        blockProto.writeTo(blockOutputStream);
        return blockOutputStream.toByteArray();
    }

    @FunctionalInterface
    public static interface CheckedFunction2<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws IOException;
    }
}

