/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;

class ExcessRedundancyMap {
    public static final Logger blockLog = NameNode.blockStateChangeLog;
    private final Map<String, LightWeightHashSet<BlockInfo>> map = new HashMap<String, LightWeightHashSet<BlockInfo>>();
    private final AtomicLong size = new AtomicLong(0L);

    ExcessRedundancyMap() {
    }

    long size() {
        return this.size.get();
    }

    @VisibleForTesting
    synchronized int getSize4Testing(String dnUuid) {
        LightWeightHashSet<BlockInfo> set = this.map.get(dnUuid);
        return set == null ? 0 : set.size();
    }

    synchronized void clear() {
        this.map.clear();
        this.size.set(0L);
    }

    synchronized boolean contains(DatanodeDescriptor dn, BlockInfo blk) {
        LightWeightHashSet<BlockInfo> set = this.map.get(dn.getDatanodeUuid());
        return set != null && set.contains(blk);
    }

    synchronized boolean add(DatanodeDescriptor dn, BlockInfo blk) {
        boolean added;
        LightWeightHashSet<BlockInfo> set = this.map.get(dn.getDatanodeUuid());
        if (set == null) {
            set = new LightWeightHashSet();
            this.map.put(dn.getDatanodeUuid(), set);
        }
        if (added = set.add(blk)) {
            this.size.incrementAndGet();
            blockLog.debug("BLOCK* ExcessRedundancyMap.add({}, {})", (Object)dn, (Object)blk);
        }
        return added;
    }

    synchronized boolean remove(DatanodeDescriptor dn, BlockInfo blk) {
        LightWeightHashSet<BlockInfo> set = this.map.get(dn.getDatanodeUuid());
        if (set == null) {
            return false;
        }
        boolean removed = set.remove(blk);
        if (removed) {
            this.size.decrementAndGet();
            blockLog.debug("BLOCK* ExcessRedundancyMap.remove({}, {})", (Object)dn, (Object)blk);
            if (set.isEmpty()) {
                this.map.remove(dn.getDatanodeUuid());
            }
        }
        return removed;
    }
}

