/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.sps;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockPinningException;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.sps.BlockMovementStatus;
import org.apache.hadoop.hdfs.server.protocol.BlockStorageMovementCommand;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDispatcher.class);
    private final boolean connectToDnViaHostname;
    private final int socketTimeout;
    private final int ioFileBufferSize;

    public BlockDispatcher(int sockTimeout, int ioFileBuffSize, boolean connectToDatanodeViaHostname) {
        this.socketTimeout = sockTimeout;
        this.ioFileBufferSize = ioFileBuffSize;
        this.connectToDnViaHostname = connectToDatanodeViaHostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BlockMovementStatus moveBlock(BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo, SaslDataTransferClient saslClient, ExtendedBlock eb, Socket sock, DataEncryptionKeyFactory km, Token<BlockTokenIdentifier> accessToken) {
        BlockMovementStatus blockMovementStatus;
        LOG.info("Start moving block:{} from src:{} to destin:{} to satisfy storageType, sourceStoragetype:{} and destinStoragetype:{}", new Object[]{blkMovingInfo.getBlock(), blkMovingInfo.getSource(), blkMovingInfo.getTarget(), blkMovingInfo.getSourceStorageType(), blkMovingInfo.getTargetStorageType()});
        DataOutputStream out = null;
        DataInputStream in = null;
        try {
            NetUtils.connect(sock, NetUtils.createSocketAddr(blkMovingInfo.getTarget().getXferAddr(this.connectToDnViaHostname)), this.socketTimeout);
            sock.setSoTimeout(this.socketTimeout * 5);
            sock.setKeepAlive(true);
            OutputStream unbufOut = sock.getOutputStream();
            InputStream unbufIn = sock.getInputStream();
            LOG.debug("Connecting to datanode {}", (Object)blkMovingInfo.getTarget());
            IOStreamPair saslStreams = saslClient.socketSend(sock, unbufOut, unbufIn, km, accessToken, blkMovingInfo.getTarget());
            unbufOut = saslStreams.out;
            unbufIn = saslStreams.in;
            out = new DataOutputStream(new BufferedOutputStream(unbufOut, this.ioFileBufferSize));
            in = new DataInputStream(new BufferedInputStream(unbufIn, this.ioFileBufferSize));
            BlockDispatcher.sendRequest(out, eb, accessToken, blkMovingInfo.getSource(), blkMovingInfo.getTargetStorageType());
            BlockDispatcher.receiveResponse(in);
            LOG.info("Successfully moved block:{} from src:{} to destin:{} for satisfying storageType:{}", new Object[]{blkMovingInfo.getBlock(), blkMovingInfo.getSource(), blkMovingInfo.getTarget(), blkMovingInfo.getTargetStorageType()});
            blockMovementStatus = BlockMovementStatus.DN_BLK_STORAGE_MOVEMENT_SUCCESS;
            IOUtils.closeStream(out);
        }
        catch (BlockPinningException e) {
            LOG.debug("Pinned block can't be moved, so skipping block:{}", (Object)blkMovingInfo.getBlock(), (Object)e);
            BlockMovementStatus blockMovementStatus2 = BlockMovementStatus.DN_BLK_STORAGE_MOVEMENT_SUCCESS;
            return blockMovementStatus2;
        }
        catch (IOException e2) {
            LOG.warn("Failed to move block:{} from src:{} to destin:{} to satisfy storageType:{}", new Object[]{blkMovingInfo.getBlock(), blkMovingInfo.getSource(), blkMovingInfo.getTarget(), blkMovingInfo.getTargetStorageType(), e2});
            BlockMovementStatus blockMovementStatus3 = BlockMovementStatus.DN_BLK_STORAGE_MOVEMENT_FAILURE;
            return blockMovementStatus3;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(out);
            IOUtils.closeStream(in);
            IOUtils.closeSocket(sock);
        }
        IOUtils.closeStream(in);
        IOUtils.closeSocket(sock);
        return blockMovementStatus;
    }

    private static void sendRequest(DataOutputStream out, ExtendedBlock eb, Token<BlockTokenIdentifier> accessToken, DatanodeInfo source, StorageType targetStorageType) throws IOException {
        new Sender(out).replaceBlock(eb, targetStorageType, accessToken, source.getDatanodeUuid(), source, null);
    }

    private static void receiveResponse(DataInputStream in) throws IOException {
        DataTransferProtos.BlockOpResponseProto response = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(in));
        while (response.getStatus() == DataTransferProtos.Status.IN_PROGRESS) {
            response = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(in));
        }
        String logInfo = "reportedBlock move is failed";
        DataTransferProtoUtil.checkBlockOpStatus(response, logInfo);
    }
}

