/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.datamodel;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;

public class DiskBalancerDataNode
implements Comparable<DiskBalancerDataNode> {
    private double nodeDataDensity;
    private Map<String, DiskBalancerVolumeSet> volumeSets;
    private String dataNodeUUID;
    private String dataNodeIP;
    private int dataNodePort;
    private String dataNodeName;
    private int volumeCount;

    public DiskBalancerDataNode() {
    }

    public DiskBalancerDataNode(String dataNodeID) {
        this.dataNodeUUID = dataNodeID;
        this.volumeSets = new HashMap<String, DiskBalancerVolumeSet>();
    }

    public String getDataNodeIP() {
        return this.dataNodeIP;
    }

    public void setDataNodeIP(String ipaddress) {
        this.dataNodeIP = ipaddress;
    }

    public int getDataNodePort() {
        return this.dataNodePort;
    }

    public void setDataNodePort(int port) {
        this.dataNodePort = port;
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public void setDataNodeName(String name) {
        this.dataNodeName = name;
    }

    public Map<String, DiskBalancerVolumeSet> getVolumeSets() {
        return this.volumeSets;
    }

    public String getDataNodeUUID() {
        return this.dataNodeUUID;
    }

    public void setDataNodeUUID(String nodeID) {
        this.dataNodeUUID = nodeID;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DiskBalancerDataNode that = (DiskBalancerDataNode)obj;
        return this.dataNodeUUID.equals(that.getDataNodeUUID());
    }

    @Override
    public int compareTo(DiskBalancerDataNode that) {
        Preconditions.checkNotNull(that);
        if (Double.compare(this.nodeDataDensity - that.getNodeDataDensity(), 0.0) < 0) {
            return -1;
        }
        if (Double.compare(this.nodeDataDensity - that.getNodeDataDensity(), 0.0) == 0) {
            return 0;
        }
        if (Double.compare(this.nodeDataDensity - that.getNodeDataDensity(), 0.0) > 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public double getNodeDataDensity() {
        return this.nodeDataDensity;
    }

    public void computeNodeDensity() {
        double sum = 0.0;
        int volcount = 0;
        for (DiskBalancerVolumeSet vset : this.volumeSets.values()) {
            for (DiskBalancerVolume vol : vset.getVolumes()) {
                sum += Math.abs(vol.getVolumeDataDensity());
                ++volcount;
            }
        }
        this.nodeDataDensity = sum;
        this.volumeCount = volcount;
    }

    public boolean isBalancingNeeded(double threshold) {
        for (DiskBalancerVolumeSet vSet : this.getVolumeSets().values()) {
            if (!vSet.isBalancingNeeded(threshold)) continue;
            return true;
        }
        return false;
    }

    public void addVolume(DiskBalancerVolume volume) throws Exception {
        DiskBalancerVolumeSet vSet;
        Preconditions.checkNotNull(volume, "volume cannot be null");
        Preconditions.checkNotNull(this.volumeSets, "volume sets cannot be null");
        Preconditions.checkNotNull(volume.getStorageType(), "storage type cannot be null");
        String volumeSetKey = volume.getStorageType();
        if (this.volumeSets.containsKey(volumeSetKey)) {
            vSet = this.volumeSets.get(volumeSetKey);
        } else {
            vSet = new DiskBalancerVolumeSet(volume.isTransient());
            vSet.setStorageType(volumeSetKey);
            this.volumeSets.put(volumeSetKey, vSet);
        }
        vSet.addVolume(volume);
        this.computeNodeDensity();
    }

    public int getVolumeCount() {
        return this.volumeCount;
    }
}

