/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.fieldsel;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.fieldsel.FieldSelectionHelper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FieldSelectionReducer<K, V>
extends Reducer<Text, Text, Text, Text> {
    private String fieldSeparator = "\t";
    private String reduceOutputKeyValueSpec;
    private List<Integer> reduceOutputKeyFieldList = new ArrayList<Integer>();
    private List<Integer> reduceOutputValueFieldList = new ArrayList<Integer>();
    private int allReduceValueFieldsFrom = -1;
    public static final Logger LOG = LoggerFactory.getLogger("FieldSelectionMapReduce");

    @Override
    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.fieldSeparator = conf.get("mapreduce.fieldsel.data.field.separator", "\t");
        this.reduceOutputKeyValueSpec = conf.get("mapreduce.fieldsel.reduce.output.key.value.fields.spec", "0-:");
        this.allReduceValueFieldsFrom = FieldSelectionHelper.parseOutputKeyValueSpec(this.reduceOutputKeyValueSpec, this.reduceOutputKeyFieldList, this.reduceOutputValueFieldList);
        LOG.info(FieldSelectionHelper.specToString(this.fieldSeparator, this.reduceOutputKeyValueSpec, this.allReduceValueFieldsFrom, this.reduceOutputKeyFieldList, this.reduceOutputValueFieldList));
    }

    @Override
    public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        String keyStr = key.toString() + this.fieldSeparator;
        for (Text val : values) {
            FieldSelectionHelper helper = new FieldSelectionHelper();
            helper.extractOutputKeyValue(keyStr, val.toString(), this.fieldSeparator, this.reduceOutputKeyFieldList, this.reduceOutputValueFieldList, this.allReduceValueFieldsFrom, false, false);
            context.write(helper.getKey(), helper.getValue());
        }
    }
}

