/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.prestosql.array.ObjectBigArray;
import io.prestosql.array.ReferenceCountMap;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import io.prestosql.spi.snapshot.RestorableConfig;
import java.io.Serializable;
import org.openjdk.jol.info.ClassLayout;

@RestorableConfig(uncapturedFields={"trackedObjects"})
public final class BlockBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BlockBigArray.class).instanceSize();
    private final ObjectBigArray<Block> array;
    private final ReferenceCountMap trackedObjects = new ReferenceCountMap();
    private long sizeOfBlocks;

    public BlockBigArray() {
        this.array = new ObjectBigArray();
    }

    public BlockBigArray(Block block) {
        this.array = new ObjectBigArray(block);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfBlocks + this.trackedObjects.sizeOf();
    }

    public Block get(long index) {
        return this.array.get(index);
    }

    public <T> void set(long index, Block<T> value) {
        Block currentValue = this.array.get(index);
        if (currentValue != null) {
            currentValue.retainedBytesForEachPart((object, size) -> {
                if (currentValue == object) {
                    this.sizeOfBlocks -= size.longValue();
                    return;
                }
                if (this.trackedObjects.decrementAndGet(object) == 0) {
                    this.sizeOfBlocks -= size.longValue();
                }
            });
        }
        if (value != null) {
            value.retainedBytesForEachPart((object, size) -> {
                if (value == object) {
                    this.sizeOfBlocks += size.longValue();
                    return;
                }
                if (this.trackedObjects.incrementAndGet(object) == 1) {
                    this.sizeOfBlocks += size.longValue();
                }
            });
        }
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        BlockBigArrayState myState = new BlockBigArrayState();
        myState.array = this.array.captureBlockBigArray(serdeProvider);
        myState.sizeOfBlocks = this.sizeOfBlocks;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        BlockBigArrayState myState = (BlockBigArrayState)state;
        this.array.restoreBlockBigArray(myState.array, serdeProvider);
        this.sizeOfBlocks = myState.sizeOfBlocks;
    }

    private static class BlockBigArrayState
    implements Serializable {
        private Object array;
        private long sizeOfBlocks;

        private BlockBigArrayState() {
        }
    }
}

