/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.SizeOf;
import io.prestosql.array.BigArrays;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import java.io.Serializable;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class BooleanBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfBooleanArray((int)1024);
    private final boolean initialValue;
    private boolean[][] array;
    private int capacity;
    private int segments;

    public BooleanBigArray() {
        this(false);
    }

    public BooleanBigArray(boolean initialValue) {
        this.initialValue = initialValue;
        this.array = new boolean[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public boolean get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, boolean value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public long getCapacity() {
        return this.capacity;
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (boolean[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        boolean[] newSegment = new boolean[1024];
        if (this.initialValue) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        BooleanBigArrayState myState = new BooleanBigArrayState();
        boolean[][] capturedArray = new boolean[this.array.length][];
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            capturedArray[i] = (boolean[])this.array[i].clone();
        }
        BooleanBigArrayState.access$102(myState, capturedArray);
        myState.capacity = this.capacity;
        myState.segments = this.segments;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        BooleanBigArrayState myState = (BooleanBigArrayState)state;
        this.array = myState.array;
        this.capacity = myState.capacity;
        this.segments = myState.segments;
    }

    private static class BooleanBigArrayState
    implements Serializable {
        private boolean[][] array;
        private int capacity;
        private int segments;

        private BooleanBigArrayState() {
        }

        static /* synthetic */ boolean[][] access$102(BooleanBigArrayState x0, boolean[][] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

