/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.SizeOf;
import io.prestosql.array.BigArrays;
import io.prestosql.array.IntBigArrays;
import io.prestosql.array.IntComparator;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import java.io.Serializable;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class IntBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfIntArray((int)1024);
    private final int initialValue;
    private int[][] array;
    private int capacity;
    private int segments;

    public IntBigArray() {
        this(0);
    }

    public IntBigArray(int initialValue) {
        this.initialValue = initialValue;
        this.array = new int[1024][];
        this.allocateNewSegment();
    }

    public int[][] getSegments() {
        return this.array;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public int get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, int value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        int[] nArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        nArray[n] = nArray[n] + 1;
    }

    public void add(long index, int value) {
        int[] nArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        nArray[n] = nArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public void fill(int value) {
        for (int[] ints : this.array) {
            if (ints == null) {
                return;
            }
            Arrays.fill(ints, value);
        }
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (int[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        int[] newSegment = new int[1024];
        if (this.initialValue != 0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }

    public void sort(int from, int to, IntComparator comparator) {
        IntBigArrays.quickSort(this.array, from, to, comparator);
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        IntBigArrayState myState = new IntBigArrayState();
        int[][] capturedArray = new int[this.array.length][];
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            capturedArray[i] = (int[])this.array[i].clone();
        }
        IntBigArrayState.access$102(myState, capturedArray);
        myState.capacity = this.capacity;
        myState.segments = this.segments;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        IntBigArrayState myState = (IntBigArrayState)state;
        this.array = myState.array;
        this.capacity = myState.capacity;
        this.segments = myState.segments;
    }

    private static class IntBigArrayState
    implements Serializable {
        private int[][] array;
        private int capacity;
        private int segments;

        private IntBigArrayState() {
        }

        static /* synthetic */ int[][] access$102(IntBigArrayState x0, int[][] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

