/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.SizeOf;
import io.prestosql.array.BigArrays;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import java.io.Serializable;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class LongBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfLongArray((int)1024);
    private final long initialValue;
    private long[][] array;
    private int capacity;
    private int segments;

    public LongBigArray() {
        this(0L);
    }

    public LongBigArray(long initialValue) {
        this.initialValue = initialValue;
        this.array = new long[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public long get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public long[] getSegment(long index) {
        return this.array[BigArrays.segment(index)];
    }

    public int getOffset(long index) {
        return BigArrays.offset(index);
    }

    public void set(long index, long value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + 1L;
    }

    public void add(long index, long value) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (long[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        long[] newSegment = new long[1024];
        if (this.initialValue != 0L) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        LongBigArrayState myState = new LongBigArrayState();
        long[][] capturedArray = new long[this.array.length][];
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            capturedArray[i] = (long[])this.array[i].clone();
        }
        LongBigArrayState.access$102(myState, capturedArray);
        myState.capacity = this.capacity;
        myState.segments = this.segments;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        LongBigArrayState myState = (LongBigArrayState)state;
        this.array = myState.array;
        this.capacity = myState.capacity;
        this.segments = myState.segments;
    }

    private static class LongBigArrayState
    implements Serializable {
        private long[][] array;
        private int capacity;
        private int segments;

        private LongBigArrayState() {
        }

        static /* synthetic */ long[][] access$102(LongBigArrayState x0, long[][] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

