/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.array.BigArrays;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openjdk.jol.info.ClassLayout;

public final class ObjectBigArray<T> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ObjectBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfObjectArray((int)1024);
    private final Object initialValue;
    private Object[][] array;
    private int capacity;
    private int segments;

    public ObjectBigArray() {
        this(null);
    }

    public ObjectBigArray(Object initialValue) {
        this.initialValue = initialValue;
        this.array = new Object[1024][];
        this.allocateNewSegment();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public T get(long index) {
        return (T)this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, T value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public boolean replace(long index, T value) {
        Object[] segment = this.array[BigArrays.segment(index)];
        boolean existed = segment[BigArrays.offset(index)] != null;
        segment[BigArrays.offset((long)index)] = value;
        return existed;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (Object[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        Object[] newSegment = new Object[1024];
        if (this.initialValue != null) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }

    public Object captureBlockBigArray(BlockEncodingSerdeProvider serdeProvider) {
        BlockObjectBigArrayState myState = new BlockObjectBigArrayState();
        myState.capacity = this.capacity;
        myState.array = new HashMap();
        HashMap<Block, List<Location>> blockLocationMap = new HashMap<Block, List<Location>>();
        int start = -1;
        Object oldBlock = null;
        for (int i = 0; i < this.capacity; ++i) {
            Block currentBlock = (Block)this.get(i);
            if (currentBlock != null) {
                if (oldBlock == null) {
                    start = i;
                    oldBlock = currentBlock;
                    continue;
                }
                if (oldBlock.equals(currentBlock)) continue;
                this.storeBlockLocation(blockLocationMap, (Block)oldBlock, start, i);
                start = i;
                oldBlock = currentBlock;
                continue;
            }
            if (oldBlock == null) continue;
            this.storeBlockLocation(blockLocationMap, (Block)oldBlock, start, i);
            oldBlock = null;
            start = -1;
        }
        if (oldBlock != null) {
            this.storeBlockLocation((Map<Block, List<Location>>)blockLocationMap, (Block)oldBlock, start, this.capacity);
        }
        for (Map.Entry entry : blockLocationMap.entrySet()) {
            myState.array.put(this.serializeBlock((Block)entry.getKey(), serdeProvider.getBlockEncodingSerde()), entry.getValue());
        }
        return myState;
    }

    public void restoreBlockBigArray(Object state, BlockEncodingSerdeProvider serdeProvider) {
        BlockObjectBigArrayState myState = (BlockObjectBigArrayState)state;
        this.array = new Object[1024][];
        this.segments = 0;
        this.capacity = 0;
        this.ensureCapacity(myState.capacity);
        for (Map.Entry entry : myState.array.entrySet()) {
            Slice inputSlice = Slices.wrappedBuffer((byte[])((byte[])entry.getKey()));
            Block block = serdeProvider.getBlockEncodingSerde().readBlock((SliceInput)inputSlice.getInput());
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Location location = (Location)((List)entry.getValue()).get(i);
                for (int j = location.start; j < location.end; ++j) {
                    this.set(j, block);
                }
            }
        }
    }

    private void storeBlockLocation(Map<Block, List<Location>> blockLocationMap, Block block, int start, int end) {
        if (blockLocationMap.containsKey(block)) {
            blockLocationMap.get(block).add(new Location(start, end));
        } else {
            blockLocationMap.put(block, new ArrayList<Location>(Collections.singletonList(new Location(start, end))));
        }
    }

    private byte[] serializeBlock(Block block, BlockEncodingSerde serde) {
        DynamicSliceOutput output = new DynamicSliceOutput(0);
        serde.writeBlock((SliceOutput)output, block);
        return output.getUnderlyingSlice().getBytes();
    }

    public Object capture(Function<Object, Object> captureFunction) {
        ObjectBigArrayState myState = new ObjectBigArrayState();
        ObjectBigArrayState.access$702(myState, new Object[this.array.length][]);
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            ((ObjectBigArrayState)myState).array[i] = new Object[this.array[i].length];
            for (int j = 0; j < this.array[i].length; ++j) {
                if (this.array[i][j] == null) continue;
                ((ObjectBigArrayState)myState).array[i][j] = captureFunction.apply(this.array[i][j]);
            }
        }
        myState.capacity = this.capacity;
        myState.segments = this.segments;
        return myState;
    }

    public void restore(Function<Object, Object> restoreFunction, Object state) {
        ObjectBigArrayState myState = (ObjectBigArrayState)state;
        Object[][] restoredArray = new Object[myState.array.length][];
        for (int i = 0; i < myState.array.length; ++i) {
            if (myState.array[i] == null) continue;
            restoredArray[i] = new Object[myState.array[i].length];
            for (int j = 0; j < myState.array[i].length; ++j) {
                if (myState.array[i][j] == null) continue;
                restoredArray[i][j] = restoreFunction.apply(myState.array[i][j]);
            }
        }
        this.array = restoredArray;
        this.capacity = myState.capacity;
        this.segments = myState.segments;
    }

    private static class ObjectBigArrayState
    implements Serializable {
        private Object[][] array;
        private int capacity;
        private int segments;

        private ObjectBigArrayState() {
        }

        static /* synthetic */ Object[][] access$702(ObjectBigArrayState x0, Object[][] x1) {
            x0.array = x1;
            return x1;
        }
    }

    private static class BlockObjectBigArrayState {
        private Map<byte[], List<Location>> array;
        private int capacity;

        private BlockObjectBigArrayState() {
        }
    }

    private static class Location
    implements Serializable {
        private final int start;
        private final int end;

        private Location(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

