/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.SizeOf;
import io.prestosql.array.BigArrays;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import java.io.Serializable;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class ShortBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfShortArray((int)1024);
    private final short initialValue;
    private short[][] array;
    private int capacity;
    private int segments;

    public ShortBigArray() {
        this(0);
    }

    public ShortBigArray(short initialValue) {
        this.initialValue = initialValue;
        this.array = new short[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public short get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, short value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        short[] sArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        sArray[n] = (short)(sArray[n] + 1);
    }

    public void add(long index, long value) {
        short[] sArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        sArray[n] = (short)((long)sArray[n] + value);
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (short[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        short[] newSegment = new short[1024];
        if (this.initialValue != 0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        ShortBigArrayState myState = new ShortBigArrayState();
        ShortBigArrayState.access$102(myState, this.array);
        myState.capacity = this.capacity;
        myState.segments = this.segments;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        ShortBigArrayState myState = (ShortBigArrayState)state;
        this.array = myState.array;
        this.capacity = myState.capacity;
        this.segments = myState.segments;
    }

    private static class ShortBigArrayState
    implements Serializable {
        private short[][] array;
        private int capacity;
        private int segments;

        private ShortBigArrayState() {
        }

        static /* synthetic */ short[][] access$102(ShortBigArrayState x0, short[][] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

