/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.array;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.array.ReferenceCountMap;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.Restorable;
import io.prestosql.spi.snapshot.RestorableConfig;
import java.io.Serializable;
import java.util.function.Function;
import org.openjdk.jol.info.ClassLayout;

@RestorableConfig(uncapturedFields={"trackedSlices"})
public final class SliceBigArray
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceBigArray.class).instanceSize();
    private static final int SLICE_INSTANCE_SIZE = ClassLayout.parseClass(Slice.class).instanceSize();
    private final ObjectBigArray<Slice> array;
    private final ReferenceCountMap trackedSlices = new ReferenceCountMap();
    private long sizeOfSlices;

    public SliceBigArray() {
        this.array = new ObjectBigArray();
    }

    public SliceBigArray(Slice slice) {
        this.array = new ObjectBigArray(slice);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfSlices + this.trackedSlices.sizeOf();
    }

    public Slice get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Slice value) {
        this.updateRetainedSize(index, value);
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    private void updateRetainedSize(long index, Slice value) {
        int sliceReferenceCount;
        int baseReferenceCount;
        Slice currentValue = this.array.get(index);
        if (currentValue != null) {
            baseReferenceCount = this.trackedSlices.decrementAndGet(currentValue.getBase());
            sliceReferenceCount = this.trackedSlices.decrementAndGet(currentValue);
            if (baseReferenceCount == 0) {
                this.sizeOfSlices -= currentValue.getRetainedSize();
            } else if (sliceReferenceCount == 0) {
                this.sizeOfSlices -= (long)SLICE_INSTANCE_SIZE;
            }
        }
        if (value != null) {
            baseReferenceCount = this.trackedSlices.incrementAndGet(value.getBase());
            sliceReferenceCount = this.trackedSlices.incrementAndGet(value);
            if (baseReferenceCount == 1) {
                this.sizeOfSlices += value.getRetainedSize();
            } else if (sliceReferenceCount == 1) {
                this.sizeOfSlices += (long)SLICE_INSTANCE_SIZE;
            }
        }
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        SliceBigArrayState myState = new SliceBigArrayState();
        Function<Object, Object> captureFunction = arrayContent -> ((Slice)arrayContent).getBytes();
        myState.array = this.array.capture(captureFunction);
        myState.sizeOfSlices = this.sizeOfSlices;
        return myState;
    }

    public void restore(Object state, BlockEncodingSerdeProvider serdeProvider) {
        SliceBigArrayState myState = (SliceBigArrayState)state;
        Function<Object, Object> restoreFunction = arrayState -> Slices.wrappedBuffer((byte[])((byte[])arrayState));
        this.array.restore(restoreFunction, myState.array);
        this.sizeOfSlices = myState.sizeOfSlices;
    }

    private static class SliceBigArrayState
    implements Serializable {
        private Object array;
        private long sizeOfSlices;

        private SliceBigArrayState() {
        }
    }
}

