/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import io.prestosql.client.ClientSelectedRole;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final String clientInfo;
    private final String catalog;
    private final String schema;
    private final String path;
    private final ZoneId timeZone;
    private final Locale locale;
    private final Map<String, String> resourceEstimates;
    private final Map<String, String> properties;
    private final Map<String, String> preparedStatements;
    private final Map<String, ClientSelectedRole> roles;
    private final Map<String, String> extraCredentials;
    private final String transactionId;
    private final Duration clientRequestTimeout;
    private final boolean timeInMilliseconds;

    public static Builder builder(ClientSession clientSession) {
        return new Builder(clientSession);
    }

    public static ClientSession stripTransactionId(ClientSession session) {
        return ClientSession.builder(session).withoutTransactionId().build();
    }

    public ClientSession(URI server, String user, String source, Optional<String> traceToken, Set<String> clientTags, String clientInfo, String catalog, String schema, String path, ZoneId timeZone, Locale locale, Map<String, String> resourceEstimates, Map<String, String> properties, Map<String, String> preparedStatements, Map<String, ClientSelectedRole> roles, Map<String, String> extraCredentials, String transactionId, Duration clientRequestTimeout) {
        this(server, user, source, traceToken, clientTags, clientInfo, catalog, schema, path, timeZone, locale, resourceEstimates, properties, preparedStatements, roles, extraCredentials, transactionId, clientRequestTimeout, false);
    }

    public ClientSession(URI server, String user, String source, Optional<String> traceToken, Set<String> clientTags, String clientInfo, String catalog, String schema, String path, ZoneId timeZone, Locale locale, Map<String, String> resourceEstimates, Map<String, String> properties, Map<String, String> preparedStatements, Map<String, ClientSelectedRole> roles, Map<String, String> extraCredentials, String transactionId, Duration clientRequestTimeout, boolean timeInMilliseconds) {
        this.server = Objects.requireNonNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientInfo = clientInfo;
        this.catalog = catalog;
        this.schema = schema;
        this.path = path;
        this.locale = locale;
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.transactionId = transactionId;
        this.resourceEstimates = ImmutableMap.copyOf(Objects.requireNonNull(resourceEstimates, "resourceEstimates is null"));
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.roles = ImmutableMap.copyOf(Objects.requireNonNull(roles, "roles is null"));
        this.extraCredentials = ImmutableMap.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
        this.clientRequestTimeout = clientRequestTimeout;
        this.timeInMilliseconds = timeInMilliseconds;
        for (String clientTag : clientTags) {
            Preconditions.checkArgument((!clientTag.contains(",") ? 1 : 0) != 0, (Object)"client tag cannot contain ','");
        }
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Resource name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Resource name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Resource name is not US_ASCII: %s", (Object)entry.getKey());
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Session property name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Session property value is not US_ASCII: %s", (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraCredentials.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Credential name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Credential name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Credential name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Credential value is not US_ASCII: %s", (Object)entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getPath() {
        return this.path;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Map<String, ClientSelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isDebug() {
        return false;
    }

    public Duration getClientRequestTimeout() {
        return this.clientRequestTimeout;
    }

    public boolean isTimeInMilliseconds() {
        return this.timeInMilliseconds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.server).add("user", (Object)this.user).add("clientTags", this.clientTags).add("clientInfo", (Object)this.clientInfo).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("path", (Object)this.path).add("traceToken", this.traceToken.orElse(null)).add("timeZone", (Object)this.timeZone).add("locale", (Object)this.locale).add("properties", this.properties).add("transactionId", (Object)this.transactionId).omitNullValues().toString();
    }

    public static final class Builder {
        private URI server;
        private String user;
        private String source;
        private Optional<String> traceToken;
        private Set<String> clientTags;
        private String clientInfo;
        private String catalog;
        private String schema;
        private String path;
        private ZoneId timeZone;
        private Locale locale;
        private Map<String, String> resourceEstimates;
        private Map<String, String> properties;
        private Map<String, String> preparedStatements;
        private Map<String, ClientSelectedRole> roles;
        private Map<String, String> credentials;
        private String transactionId;
        private Duration clientRequestTimeout;
        private boolean timeInMilliseconds;

        private Builder(ClientSession clientSession) {
            Objects.requireNonNull(clientSession, "clientSession is null");
            this.server = clientSession.getServer();
            this.user = clientSession.getUser();
            this.source = clientSession.getSource();
            this.traceToken = clientSession.getTraceToken();
            this.clientTags = clientSession.getClientTags();
            this.clientInfo = clientSession.getClientInfo();
            this.catalog = clientSession.getCatalog();
            this.schema = clientSession.getSchema();
            this.path = clientSession.getPath();
            this.timeZone = clientSession.getTimeZone();
            this.locale = clientSession.getLocale();
            this.resourceEstimates = clientSession.getResourceEstimates();
            this.properties = clientSession.getProperties();
            this.preparedStatements = clientSession.getPreparedStatements();
            this.roles = clientSession.getRoles();
            this.credentials = clientSession.getExtraCredentials();
            this.transactionId = clientSession.getTransactionId();
            this.clientRequestTimeout = clientSession.getClientRequestTimeout();
            this.timeInMilliseconds = clientSession.isTimeInMilliseconds();
        }

        public Builder withCatalog(String catalog) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            return this;
        }

        public Builder withSchema(String schema) {
            this.schema = Objects.requireNonNull(schema, "schema is null");
            return this;
        }

        public Builder withPath(String path) {
            this.path = Objects.requireNonNull(path, "path is null");
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = Objects.requireNonNull(properties, "properties is null");
            return this;
        }

        public Builder withRoles(Map<String, ClientSelectedRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withCredentials(Map<String, String> credentials) {
            this.credentials = Objects.requireNonNull(credentials, "extraCredentials is null");
            return this;
        }

        public Builder withPreparedStatements(Map<String, String> preparedStatements) {
            this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
            return this;
        }

        public Builder withoutTransactionId() {
            this.transactionId = null;
            return this;
        }

        public ClientSession build() {
            return new ClientSession(this.server, this.user, this.source, this.traceToken, this.clientTags, this.clientInfo, this.catalog, this.schema, this.path, this.timeZone, this.locale, this.resourceEstimates, this.properties, this.preparedStatements, this.roles, this.credentials, this.transactionId, this.clientRequestTimeout, this.timeInMilliseconds);
        }
    }
}

