/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.client.ClientTypeSignatureParameter;
import io.prestosql.client.NamedClientTypeSignature;
import io.prestosql.client.ParameterKind;
import io.prestosql.client.RowFieldName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClientTypeSignature {
    private static final Pattern PATTERN = Pattern.compile(".*[<>,].*");
    private final String rawType;
    private final List<ClientTypeSignatureParameter> arguments;
    public static final int VARCHAR_UNBOUNDED_LENGTH = Integer.MAX_VALUE;

    public ClientTypeSignature(String rawType) {
        this(rawType, (List<ClientTypeSignatureParameter>)ImmutableList.of());
    }

    public ClientTypeSignature(String rawType, List<ClientTypeSignatureParameter> arguments) {
        this(rawType, (List<ClientTypeSignature>)ImmutableList.of(), (List<Object>)ImmutableList.of(), arguments);
    }

    @JsonCreator
    public ClientTypeSignature(@JsonProperty(value="rawType") String rawType, @JsonProperty(value="typeArguments") List<ClientTypeSignature> typeArguments, @JsonProperty(value="literalArguments") List<Object> literalArguments, @JsonProperty(value="arguments") List<ClientTypeSignatureParameter> arguments) {
        Objects.requireNonNull(rawType, "rawType is null");
        this.rawType = rawType;
        Preconditions.checkArgument((!rawType.isEmpty() ? 1 : 0) != 0, (Object)"rawType is empty");
        Preconditions.checkArgument((!PATTERN.matcher(rawType).matches() ? 1 : 0) != 0, (String)"Bad characters in rawType type: %s", (Object)rawType);
        if (arguments != null) {
            this.arguments = Collections.unmodifiableList(new ArrayList<ClientTypeSignatureParameter>(arguments));
        } else {
            Objects.requireNonNull(typeArguments, "typeArguments is null");
            Objects.requireNonNull(literalArguments, "literalArguments is null");
            ImmutableList.Builder convertedArguments = ImmutableList.builder();
            if (rawType.equals("row")) {
                Preconditions.checkArgument((typeArguments.size() == literalArguments.size() ? 1 : 0) != 0);
                for (int i = 0; i < typeArguments.size(); ++i) {
                    Object value = literalArguments.get(i);
                    Preconditions.checkArgument((boolean)(value instanceof String), (String)"Expected literalArgument %s in %s to be a string", (int)i, literalArguments);
                    convertedArguments.add((Object)ClientTypeSignatureParameter.ofNamedType(new NamedClientTypeSignature(Optional.of(new RowFieldName((String)value, false)), typeArguments.get(i))));
                }
            } else {
                Preconditions.checkArgument((boolean)literalArguments.isEmpty(), (Object)"Unexpected literal arguments from legacy server");
                for (ClientTypeSignature typeArgument : typeArguments) {
                    convertedArguments.add((Object)new ClientTypeSignatureParameter(ParameterKind.TYPE, typeArgument));
                }
            }
            this.arguments = convertedArguments.build();
        }
    }

    @JsonProperty
    public String getRawType() {
        return this.rawType;
    }

    @JsonProperty
    public List<ClientTypeSignatureParameter> getArguments() {
        return this.arguments;
    }

    public List<ClientTypeSignature> getArgumentsAsTypeSignatures() {
        return (List)this.arguments.stream().peek(parameter -> Preconditions.checkState((parameter.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected all parameters to be TypeSignatures but [%s] was found", (Object)parameter)).map(ClientTypeSignatureParameter::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    @Deprecated
    @JsonProperty
    public List<ClientTypeSignature> getTypeArguments() {
        ArrayList<ClientTypeSignature> result = new ArrayList<ClientTypeSignature>();
        block4: for (ClientTypeSignatureParameter argument : this.arguments) {
            switch (argument.getKind()) {
                case TYPE: {
                    result.add(argument.getTypeSignature());
                    continue block4;
                }
                case NAMED_TYPE: {
                    result.add(argument.getNamedTypeSignature().getTypeSignature());
                    continue block4;
                }
            }
            return new ArrayList<ClientTypeSignature>();
        }
        return result;
    }

    @Deprecated
    @JsonProperty
    public List<Object> getLiteralArguments() {
        ArrayList<Object> result = new ArrayList<Object>();
        block3: for (ClientTypeSignatureParameter argument : this.arguments) {
            switch (argument.getKind()) {
                case NAMED_TYPE: {
                    result.add(argument.getNamedTypeSignature().getName());
                    continue block3;
                }
            }
            return new ArrayList<Object>();
        }
        return result;
    }

    public String toString() {
        if (this.rawType.equals("row")) {
            return this.rowToString();
        }
        if (this.rawType.equals("varchar") && this.arguments.get(0).getKind() == ParameterKind.LONG && this.arguments.get(0).getLongLiteral() == Integer.MAX_VALUE) {
            return "varchar";
        }
        if (this.arguments.isEmpty()) {
            return this.rawType;
        }
        return this.rawType + this.arguments.stream().map(ClientTypeSignatureParameter::toString).collect(Collectors.joining(",", "(", ")"));
    }

    @Deprecated
    private String rowToString() {
        String fields = this.arguments.stream().map(ClientTypeSignatureParameter::getNamedTypeSignature).map(parameter -> {
            if (parameter.getName().isPresent()) {
                return String.format("%s %s", parameter.getName().get(), parameter.getTypeSignature().toString());
            }
            return parameter.getTypeSignature().toString();
        }).collect(Collectors.joining(","));
        if (fields.isEmpty()) {
            return "row";
        }
        return String.format("row(%s)", fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignature other = (ClientTypeSignature)o;
        return Objects.equals(this.rawType.toLowerCase(Locale.ENGLISH), other.rawType.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.rawType.toLowerCase(Locale.ENGLISH), this.arguments);
    }
}

