/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client.util;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.type.ArrayParametricType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharParametricType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalParametricType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapParametricType;
import io.prestosql.spi.type.P4HyperLogLogType;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowParametricType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.UnknownType;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharParametricType;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtil {
    private static final Pattern DESCRIBE_TYPE_PATTERN = Pattern.compile("(?<type>[a-zA-Z1-9 _]+)");
    private static final Map<String, ParametricType> PARAMETRIC_TYPE_MAP = new ImmutableMap.Builder().put((Object)DecimalParametricType.DECIMAL.getName(), (Object)DecimalParametricType.DECIMAL).put((Object)CharParametricType.CHAR.getName(), (Object)CharParametricType.CHAR).put((Object)VarcharParametricType.VARCHAR.getName(), (Object)VarcharParametricType.VARCHAR).put((Object)ArrayParametricType.ARRAY.getName(), (Object)ArrayParametricType.ARRAY).put((Object)MapParametricType.MAP.getName(), (Object)MapParametricType.MAP).put((Object)RowParametricType.ROW.getName(), (Object)RowParametricType.ROW).build();

    private TypeUtil() {
    }

    private static Type typeMapping(String type) {
        switch (type) {
            case "bigint": {
                return BigintType.BIGINT;
            }
            case "integer": {
                return IntegerType.INTEGER;
            }
            case "smallint": {
                return SmallintType.SMALLINT;
            }
            case "tinyint": {
                return TinyintType.TINYINT;
            }
            case "boolean": {
                return BooleanType.BOOLEAN;
            }
            case "date": {
                return DateType.DATE;
            }
            case "real": {
                return RealType.REAL;
            }
            case "double": {
                return DoubleType.DOUBLE;
            }
            case "HyperLogLog": {
                return HyperLogLogType.HYPER_LOG_LOG;
            }
            case "P4HyperLogLog": {
                return P4HyperLogLogType.P4_HYPER_LOG_LOG;
            }
            case "timestamp": {
                return TimestampType.TIMESTAMP;
            }
            case "timestamp with time zone": {
                return TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
            }
            case "time": {
                return TimeType.TIME;
            }
            case "time with time zone": {
                return TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
            }
            case "varbinary": {
                return VarbinaryType.VARBINARY;
            }
            case "unknown": {
                return UnknownType.UNKNOWN;
            }
        }
        return null;
    }

    private static Type parametricType(TypeManager typeManager, TypeSignature typeSignature) {
        String typeName = typeSignature.getBase().toLowerCase(Locale.ENGLISH);
        ParametricType parametricType = PARAMETRIC_TYPE_MAP.get(typeName);
        if (parametricType != null) {
            ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
            for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
                TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)typeManager);
                parameters.add(typeParameter);
            }
            return parametricType.createType(typeManager, parameters);
        }
        return null;
    }

    public static Type parseType(TypeManager typeManager, String typeName) {
        Type hetuType = null;
        Matcher matcher = DESCRIBE_TYPE_PATTERN.matcher(typeName);
        if (matcher.matches()) {
            String type = matcher.group("type");
            hetuType = TypeUtil.typeMapping(type);
        }
        if (hetuType == null) {
            TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)typeName);
            hetuType = TypeUtil.parametricType(typeManager, typeSignature);
        }
        if (hetuType == null) {
            throw new IllegalArgumentException("Type " + typeName + " is not supported");
        }
        return hetuType;
    }
}

