/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class NewInstanceBytecodeExpression
extends BytecodeExpression {
    private final List<BytecodeExpression> parameters;
    private final ImmutableList<ParameterizedType> parameterTypes;

    public NewInstanceBytecodeExpression(ParameterizedType type, Iterable<ParameterizedType> parameterTypes, Iterable<? extends BytecodeExpression> parameters) {
        super(type);
        this.parameterTypes = ImmutableList.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock().newObject(this.getType()).dup();
        for (BytecodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeConstructor(this.getType(), (Iterable<ParameterizedType>)this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getSimpleName() + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.parameters);
    }
}

