/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base;

import com.google.common.base.Preconditions;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import java.util.Objects;
import java.util.Optional;

public final class Versions {
    private Versions() {
    }

    public static void checkSpiVersion(ConnectorContext context, ConnectorFactory connectorFactory) {
        String spiVersion = context.getSpiVersion();
        Optional<String> pluginVersion = Versions.getPluginMavenVersion(connectorFactory);
        if (!pluginVersion.isPresent()) {
            return;
        }
        Preconditions.checkState((boolean)spiVersion.equals(pluginVersion.get()), (Object)String.format("Trino SPI version %s does not match %s connector version %s. The connector cannot be used with SPI version other than it was compiled for.", spiVersion, connectorFactory.getName(), pluginVersion.get()));
    }

    private static Optional<String> getPluginMavenVersion(ConnectorFactory connectorFactory) {
        String specificationVersion = connectorFactory.getClass().getPackage().getSpecificationVersion();
        String implementationVersion = connectorFactory.getClass().getPackage().getImplementationVersion();
        if (specificationVersion == null && implementationVersion == null) {
            return Optional.empty();
        }
        Objects.requireNonNull(specificationVersion, "specificationVersion not present when implementationVersion is present");
        Objects.requireNonNull(implementationVersion, "implementationVersion not present when specificationVersion is present");
        if (implementationVersion.matches(".*-(\\d+)-g([0-9a-f]+)(-dirty)?$")) {
            return Optional.of(specificationVersion.replaceAll("\\.0$", "") + "-SNAPSHOT");
        }
        return Optional.of(implementationVersion);
    }
}

