/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaAccessControlRule {
    private final boolean owner;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;

    @JsonCreator
    public SchemaAccessControlRule(@JsonProperty(value="owner") boolean owner, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex) {
        this.owner = owner;
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "group is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "sourceRegex is null");
    }

    public Optional<Boolean> match(String user, Set<String> groups, String schema) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true).booleanValue() && this.schemaRegex.map(regex -> regex.matcher(schema).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.owner);
        }
        return Optional.empty();
    }
}

