/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import java.util.Arrays;
import java.util.Objects;

@ThriftStruct
public final class PrestoThriftId {
    private static final int PREFIX_SUFFIX_BYTES = 8;
    private static final String FILLER = "..";
    private static final int MAX_DISPLAY_CHARACTERS = 32 + "..".length();
    private final byte[] id;

    @JsonCreator
    @ThriftConstructor
    public PrestoThriftId(@JsonProperty(value="id") byte[] id) {
        this.id = Objects.requireNonNull(id, "id is null");
    }

    @JsonProperty
    @ThriftField(value=1)
    public byte[] getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftId other = (PrestoThriftId)obj;
        return Arrays.equals(this.id, other.id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)PrestoThriftId.summarize(this.id)).toString();
    }

    @VisibleForTesting
    static String summarize(byte[] value) {
        if (value.length * 2 <= MAX_DISPLAY_CHARACTERS) {
            return BaseEncoding.base16().encode(value);
        }
        return BaseEncoding.base16().encode(value, 0, 8) + FILLER + BaseEncoding.base16().encode(value, value.length - 8, 8);
    }
}

