/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.prestosql.plugin.thrift.api.PrestoThriftBlock;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftColumnData;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftTypeUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftInteger
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final int[] ints;

    @ThriftConstructor
    public PrestoThriftInteger(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="ints") @Nullable int[] ints) {
        Preconditions.checkArgument((boolean)PrestoThriftInteger.sameSizeIfPresent(nulls, ints), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.ints = ints;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getInts() {
        return this.ints;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)IntegerType.INTEGER.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new IntArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.ints == null ? new int[numberOfRecords] : this.ints);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.ints != null) {
            return this.ints.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftInteger other = (PrestoThriftInteger)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.ints, other.ints);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.ints));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        return PrestoThriftTypeUtils.fromIntBasedBlock(block, (Type)IntegerType.INTEGER, (nulls, ints) -> PrestoThriftBlock.integerData(new PrestoThriftInteger((boolean[])nulls, (int[])ints)));
    }

    public static PrestoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return PrestoThriftTypeUtils.fromIntBasedColumn(recordSet, columnIndex, totalRecords, (nulls, ints) -> PrestoThriftBlock.integerData(new PrestoThriftInteger((boolean[])nulls, (int[])ints)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, int[] ints) {
        return nulls == null || ints == null || nulls.length == ints.length;
    }
}

