/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.prestosql.plugin.thrift.api.PrestoThriftBlock;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftColumnData;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftTypeUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftTimestamp
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final long[] timestamps;

    @ThriftConstructor
    public PrestoThriftTimestamp(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="timestamps") @Nullable long[] timestamps) {
        Preconditions.checkArgument((boolean)PrestoThriftTimestamp.sameSizeIfPresent(nulls, timestamps), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.timestamps = timestamps;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public long[] getTimestamps() {
        return this.timestamps;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)TimestampType.TIMESTAMP.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new LongArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.timestamps == null ? new long[numberOfRecords] : this.timestamps);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.timestamps != null) {
            return this.timestamps.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftTimestamp other = (PrestoThriftTimestamp)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.timestamps, other.timestamps);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.timestamps));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        return PrestoThriftTypeUtils.fromLongBasedBlock(block, (Type)TimestampType.TIMESTAMP, (nulls, longs) -> PrestoThriftBlock.timestampData(new PrestoThriftTimestamp((boolean[])nulls, (long[])longs)));
    }

    public static PrestoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return PrestoThriftTypeUtils.fromLongBasedColumn(recordSet, columnIndex, totalRecords, (nulls, longs) -> PrestoThriftBlock.timestampData(new PrestoThriftTimestamp((boolean[])nulls, (long[])longs)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, long[] timestamps) {
        return nulls == null || timestamps == null || nulls.length == timestamps.length;
    }
}

