/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.thrift.api.PrestoThriftBlock;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftColumnData;
import io.prestosql.plugin.thrift.api.datatypes.PrestoThriftTypeUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

final class SliceData
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final int[] sizes;
    private final byte[] bytes;

    public SliceData(@Nullable boolean[] nulls, @Nullable int[] sizes, @Nullable byte[] bytes) {
        Preconditions.checkArgument((boolean)PrestoThriftTypeUtils.sameSizeIfPresent(nulls, sizes), (Object)"nulls and values must be of the same size");
        Preconditions.checkArgument((PrestoThriftTypeUtils.totalSize(nulls, sizes) == (bytes != null ? bytes.length : 0) ? 1 : 0) != 0, (Object)"total bytes size doesn't match expected size");
        this.nulls = nulls;
        this.sizes = sizes;
        this.bytes = bytes;
    }

    @Nullable
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    public int[] getSizes() {
        return this.sizes;
    }

    @Nullable
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((desiredType.getJavaType() == Slice.class ? 1 : 0) != 0, (String)"type doesn't match: %s", (Object)desiredType);
        Slice values = this.bytes == null ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])this.bytes);
        int numberOfRecords = this.numberOfRecords();
        return new VariableWidthBlock(numberOfRecords, values, PrestoThriftTypeUtils.calculateOffsets(this.sizes, this.nulls, numberOfRecords), Optional.ofNullable(this.nulls));
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.sizes != null) {
            return this.sizes.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SliceData other = (SliceData)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.sizes, other.sizes) && Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.sizes), Arrays.hashCode(this.bytes));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromSliceBasedBlock(Block block, Type type, CreateSliceThriftBlockFunction create) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return create.apply(null, null, null);
        }
        boolean[] nulls1 = null;
        int[] sizes1 = null;
        byte[] bytes1 = null;
        int bytesIndex = 0;
        for (int position = 0; position < positions; ++position) {
            int length;
            if (block.isNull(position)) {
                if (nulls1 == null) {
                    nulls1 = new boolean[positions];
                }
                nulls1[position] = true;
                continue;
            }
            Slice value = type.getSlice(block, position);
            if (sizes1 == null) {
                sizes1 = new int[positions];
                int totalBytes = SliceData.totalSliceBytes(block);
                if (totalBytes > 0) {
                    bytes1 = new byte[totalBytes];
                }
            }
            sizes1[position] = length = value.length();
            if (length <= 0) continue;
            Preconditions.checkState((bytes1 != null ? 1 : 0) != 0);
            value.getBytes(0, bytes1, bytesIndex, length);
            bytesIndex += length;
        }
        Preconditions.checkState((bytes1 == null || bytesIndex == bytes1.length ? 1 : 0) != 0);
        return create.apply(nulls1, sizes1, bytes1);
    }

    private static int totalSliceBytes(Block block) {
        int totalBytes = 0;
        int positions = block.getPositionCount();
        for (int position = 0; position < positions; ++position) {
            totalBytes += block.getSliceLength(position);
        }
        return totalBytes;
    }

    public static interface CreateSliceThriftBlockFunction {
        public PrestoThriftBlock apply(boolean[] var1, int[] var2, byte[] var3);
    }
}

