/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.net.HostAndPort;
import io.airlift.concurrent.Threads;
import io.airlift.drift.protocol.TTransportException;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.units.Duration;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

class ConnectionPool
implements ConnectionManager {
    private final ConnectionManager connectionFactory;
    private final EventLoopGroup group;
    private final Cache<ConnectionKey, Future<Channel>> cachedConnections;
    private final ScheduledExecutorService maintenanceThread = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"drift-connection-maintenance"));
    @GuardedBy(value="this")
    private boolean closed;

    public ConnectionPool(ConnectionManager connectionFactory, EventLoopGroup group, int maxSize, Duration idleTimeout) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        this.group = Objects.requireNonNull(group, "group is null");
        this.cachedConnections = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterAccess(idleTimeout.toMillis(), TimeUnit.MILLISECONDS).removalListener(notification -> ConnectionPool.closeConnection((Future<Channel>)((Future)notification.getValue()))).build();
        this.maintenanceThread.scheduleWithFixedDelay(() -> this.cachedConnections.cleanUp(), 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Channel> getConnection(ConnectionManager.ConnectionParameters connectionParameters, HostAndPort address) {
        ConnectionKey key = new ConnectionKey(connectionParameters, address);
        while (true) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                Future future;
                if (this.closed) {
                    return this.group.next().newFailedFuture((Throwable)new TTransportException("Connection pool is closed"));
                }
                try {
                    future = (Future)this.cachedConnections.get((Object)key, () -> this.createConnection(key));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                if (!future.isDone()) {
                    return future;
                }
                Channel channel = (Channel)future.getNow();
                if (channel != null && channel.isOpen()) {
                    return future;
                }
                this.cachedConnections.asMap().remove(key, future);
            }
        }
    }

    private Future<Channel> createConnection(ConnectionKey key) {
        Future<Channel> future = this.connectionFactory.getConnection(key.getConnectionParameters(), key.getAddress());
        future.addListener(channelFuture -> {
            if (future.isSuccess()) {
                ((Channel)future.getNow()).closeFuture().addListener(closeFuture -> this.cachedConnections.asMap().remove(key, future));
            }
        });
        return future;
    }

    @Override
    public void returnConnection(Channel connection) {
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.cachedConnections.invalidateAll();
        }
        finally {
            this.maintenanceThread.shutdownNow();
        }
    }

    private static void closeConnection(Future<Channel> future) {
        future.addListener(ignored -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.close();
            }
        });
    }

    private static class ConnectionKey {
        private final ConnectionManager.ConnectionParameters connectionParameters;
        private final HostAndPort address;

        public ConnectionKey(ConnectionManager.ConnectionParameters connectionParameters, HostAndPort address) {
            this.connectionParameters = connectionParameters;
            this.address = address;
        }

        public ConnectionManager.ConnectionParameters getConnectionParameters() {
            return this.connectionParameters;
        }

        public HostAndPort getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            return Objects.equals(this.connectionParameters, that.connectionParameters) && Objects.equals(this.address, that.address);
        }

        public int hashCode() {
            return Objects.hash(this.connectionParameters, this.address);
        }
    }
}

