/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.codec;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.drift.transport.netty.codec.FrameInfo;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.SimpleFrameInfoDecoder;
import io.airlift.drift.transport.netty.codec.ThriftFrame;
import io.airlift.drift.transport.netty.codec.Transport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public final class HeaderTransport {
    private static final int HEADER_MAGIC = 4095;
    private static final int FRAME_HEADER_SIZE = 10;
    private static final int FLAGS_NONE = 0;
    private static final int FLAG_SUPPORT_OUT_OF_ORDER = 1;
    private static final int FLAG_SUPPORT_OUT_OF_ORDER_MASK = 1;
    private static final int NORMAL_HEADERS = 1;
    private static final int PERSISTENT_HEADERS = 1;

    private HeaderTransport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf encodeFrame(ThriftFrame frame) {
        try {
            ByteBuf encodingInfo = Unpooled.buffer((int)3);
            encodingInfo.writeByte(frame.getProtocol().getHeaderTransportId());
            encodingInfo.writeByte(0);
            ByteBuf encodedHeaders = HeaderTransport.encodeHeaders(frame.getHeaders());
            int headerSize = encodingInfo.readableBytes() + encodedHeaders.readableBytes();
            ByteBuf padding = HeaderTransport.getPadding(headerSize);
            headerSize += padding.readableBytes();
            ByteBuf frameHeader = Unpooled.buffer((int)10);
            frameHeader.writeShort(4095);
            frameHeader.writeShort(frame.isSupportOutOfOrderResponse() ? 1 : 0);
            frameHeader.writeInt(frame.getSequenceId());
            frameHeader.writeShort(headerSize >> 2);
            ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{frameHeader, encodingInfo, encodedHeaders, padding, frame.getMessage()});
            return byteBuf;
        }
        finally {
            frame.release();
        }
    }

    private static ByteBuf getPadding(int headerSize) {
        int paddingSize = 4 - headerSize % 4;
        ByteBuf padding = Unpooled.buffer((int)paddingSize);
        padding.writeZero(paddingSize);
        return padding;
    }

    private static ByteBuf encodeHeaders(Map<String, String> headers) {
        if (headers.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        int estimatedSize = 6 + headers.size() * 10;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            estimatedSize += entry.getKey().length() + entry.getValue().length();
        }
        ByteBuf headersBuffer = Unpooled.buffer((int)estimatedSize);
        headersBuffer.writeByte(1);
        HeaderTransport.writeVint(headersBuffer, headers.size());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            HeaderTransport.writeString(headersBuffer, entry.getKey());
            HeaderTransport.writeString(headersBuffer, entry.getValue());
        }
        return headersBuffer;
    }

    private static void writeString(ByteBuf out, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        HeaderTransport.writeVint(out, bytes.length);
        out.writeBytes(bytes);
    }

    private static void writeVint(ByteBuf out, int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                out.writeByte(n);
                return;
            }
            out.writeByte(n | 0x80);
            n >>>= 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThriftFrame decodeFrame(ByteBuf buffer) {
        ByteBuf messageHeader = null;
        try {
            boolean outOfOrderResponse;
            short magic = buffer.readShort();
            Verify.verify((magic == 4095 ? 1 : 0) != 0, (String)"Invalid header magic", (Object[])new Object[0]);
            short flags = buffer.readShort();
            switch (flags) {
                case 0: {
                    outOfOrderResponse = false;
                    break;
                }
                case 1: {
                    outOfOrderResponse = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported header flags: " + flags);
                }
            }
            int frameSequenceId = buffer.readInt();
            int headerSize = buffer.readShort() << 2;
            messageHeader = buffer.readBytes(headerSize);
            byte protocolId = messageHeader.readByte();
            Protocol protocol = Protocol.getProtocolByHeaderTransportId(protocolId);
            byte numberOfTransforms = messageHeader.readByte();
            if (numberOfTransforms > 0) {
                throw new IllegalArgumentException("Unsupported transform");
            }
            ImmutableMap.Builder allHeaders = ImmutableMap.builder();
            allHeaders.putAll(HeaderTransport.decodeHeaders(1, messageHeader));
            allHeaders.putAll(HeaderTransport.decodeHeaders(1, messageHeader));
            ByteBuf message = buffer.readBytes(buffer.readableBytes());
            ThriftFrame thriftFrame = new ThriftFrame(frameSequenceId, message, (Map<String, String>)allHeaders.build(), Transport.HEADER, protocol, outOfOrderResponse);
            return thriftFrame;
        }
        finally {
            if (messageHeader != null) {
                messageHeader.release();
            }
            buffer.release();
        }
    }

    private static Map<String, String> decodeHeaders(int expectedHeadersType, ByteBuf messageHeader) {
        if (messageHeader.readableBytes() == 0) {
            return ImmutableMap.of();
        }
        byte headersType = messageHeader.readByte();
        if (headersType != expectedHeadersType) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder headers = ImmutableMap.builder();
        int headerCount = HeaderTransport.readVariableLengthInt(messageHeader);
        for (int i = 0; i < headerCount; ++i) {
            String key = HeaderTransport.readString(messageHeader);
            String value = HeaderTransport.readString(messageHeader);
            headers.put((Object)key, (Object)value);
        }
        return headers.build();
    }

    private static String readString(ByteBuf messageHeader) {
        int length = HeaderTransport.readVariableLengthInt(messageHeader);
        return messageHeader.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    private static int readVariableLengthInt(ByteBuf messageHeader) {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = messageHeader.readByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<FrameInfo> tryDecodeFrameInfo(ByteBuf input) {
        ByteBuf buffer = input.retainedDuplicate();
        try {
            if (buffer.readableBytes() < 10) {
                Optional<FrameInfo> optional = Optional.empty();
                return optional;
            }
            buffer.readShort();
            short flags = buffer.readShort();
            boolean outOfOrderResponse = (flags & 1) == 1;
            int headerSequenceId = buffer.readInt();
            int headerSize = buffer.readShort() << 2;
            if (buffer.readableBytes() < headerSize) {
                Optional<FrameInfo> optional = Optional.empty();
                return optional;
            }
            byte protocolId = buffer.getByte(buffer.readerIndex());
            Protocol protocol = Protocol.getProtocolByHeaderTransportId(protocolId);
            buffer.skipBytes(headerSize);
            SimpleFrameInfoDecoder simpleFrameInfoDecoder = new SimpleFrameInfoDecoder(Transport.HEADER, protocol, outOfOrderResponse);
            Optional<FrameInfo> frameInfo = simpleFrameInfoDecoder.tryDecodeFrameInfo(buffer);
            if (frameInfo.isPresent()) {
                int messageSequenceId = frameInfo.get().getSequenceId();
                Preconditions.checkArgument((headerSequenceId == messageSequenceId ? 1 : 0) != 0, (String)"Sequence ids don't match. headerSequenceId: %s. messageSequenceId: %s", (int)headerSequenceId, (int)messageSequenceId);
            }
            Optional<FrameInfo> optional = frameInfo;
            return optional;
        }
        finally {
            buffer.release();
        }
    }
}

