/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.reflection;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.internal.ProtocolReader;
import io.airlift.drift.codec.internal.ProtocolWriter;
import io.airlift.drift.codec.internal.reflection.AbstractReflectionThriftCodec;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ThriftConstructorInjection;
import io.airlift.drift.codec.metadata.ThriftFieldInjection;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftMethodInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.protocol.TProtocolException;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReflectionThriftStructCodec<T>
extends AbstractReflectionThriftCodec<T> {
    public ReflectionThriftStructCodec(ThriftCodecManager manager, ThriftStructMetadata metadata) {
        super(manager, metadata);
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        ProtocolReader reader = new ProtocolReader(protocol);
        reader.readStructBegin();
        HashMap<Short, Object> data = new HashMap<Short, Object>(this.metadata.getFields().size());
        while (reader.nextField()) {
            short fieldId = reader.getFieldId();
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldId);
            if (codec == null) {
                reader.skipFieldData();
                continue;
            }
            ThriftFieldMetadata field = this.metadata.getField(fieldId);
            if (field.isReadOnly() || field.getType() != FieldKind.THRIFT_FIELD) {
                reader.skipFieldData();
                continue;
            }
            Object value = reader.readField(codec);
            if (value == null) {
                if (field.getRequiredness() != ThriftField.Requiredness.REQUIRED) continue;
                throw new TProtocolException("required field was not set");
            }
            data.put(fieldId, value);
        }
        reader.readStructEnd();
        return this.constructStruct(data);
    }

    @Override
    public void write(T instance, TProtocolWriter protocol) throws Exception {
        ProtocolWriter writer = new ProtocolWriter(protocol);
        writer.writeStructBegin(this.metadata.getStructName());
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Object fieldValue;
            if (fieldMetadata.isWriteOnly() || (fieldValue = this.getFieldValue(instance, fieldMetadata)) == null) continue;
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldMetadata.getId());
            writer.writeField(fieldMetadata.getName(), fieldMetadata.getId(), codec, fieldValue);
        }
        writer.writeStructEnd();
    }

    private T constructStruct(Map<Short, Object> data) throws Exception {
        Object value;
        Iterator<ThriftMethodInjection> constructor = this.metadata.getConstructorInjection().get();
        Object[] parametersValues = new Object[((ThriftConstructorInjection)((Object)constructor)).getParameters().size()];
        for (ThriftParameterInjection parameter : ((ThriftConstructorInjection)((Object)constructor)).getParameters()) {
            value = data.get(parameter.getId());
            if (value == null) {
                value = this.metadata.getField(parameter.getId()).getThriftType().getNullValue();
            }
            parametersValues[parameter.getParameterIndex()] = value;
        }
        Object instance = ReflectionThriftStructCodec.invokeConstructor(((ThriftConstructorInjection)((Object)constructor)).getConstructor(), parametersValues);
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            for (ThriftInjection injection : fieldMetadata.getInjections()) {
                Object fieldInjection;
                Object value2;
                if (!(injection instanceof ThriftFieldInjection) || (value2 = data.get(((ThriftFieldInjection)(fieldInjection = (ThriftFieldInjection)injection)).getId())) == null) continue;
                ((ThriftFieldInjection)fieldInjection).getField().set(instance, value2);
            }
        }
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            boolean shouldInvoke = false;
            Object[] parametersValues2 = new Object[methodInjection.getParameters().size()];
            for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
                Object value3 = data.get(parameter.getId());
                if (value3 == null) continue;
                parametersValues2[parameter.getParameterIndex()] = value3;
                shouldInvoke = true;
            }
            if (!shouldInvoke) continue;
            ReflectionThriftStructCodec.invokeMethod(methodInjection.getMethod(), instance, parametersValues2);
        }
        if (this.metadata.getBuilderMethod().isPresent()) {
            ThriftMethodInjection builderMethod = this.metadata.getBuilderMethod().get();
            parametersValues = new Object[builderMethod.getParameters().size()];
            for (ThriftParameterInjection parameter : builderMethod.getParameters()) {
                parametersValues[parameter.getParameterIndex()] = value = data.get(parameter.getId());
            }
            instance = ReflectionThriftStructCodec.invokeMethod(builderMethod.getMethod(), instance, parametersValues);
            ReflectionThriftStructCodec.validateCreatedInstance(this.metadata.getStructClass(), instance);
        }
        return (T)instance;
    }

    static void validateCreatedInstance(Class<?> clazz, Object instance) {
        Verify.verify((instance != null ? 1 : 0) != 0, (String)"Builder method returned a null instance", (Object[])new Object[0]);
        Verify.verify((boolean)clazz.isInstance(instance), (String)"Builder method returned instance of type %s, but an instance of %s is required", (Object)instance.getClass().getName(), (Object)clazz.getName());
    }

    static <T> T invokeConstructor(Constructor<T> constructor, Object[] args) throws Exception {
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), Exception.class);
            throw e;
        }
    }

    static Object invokeMethod(Method method, Object instance, Object[] args) throws Exception {
        try {
            return method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), Exception.class);
            throw e;
        }
    }
}

