/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.parameternames.ParameterNames;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;

public final class ReflectionHelper {
    private static final Type MAP_KEY_TYPE;
    private static final Type MAP_VALUE_TYPE;
    private static final Type ITERATOR_TYPE;
    private static final Type ITERATOR_ELEMENT_TYPE;
    private static final Type OPTIONAL_TYPE;
    private static final Type FUTURE_RETURN_TYPE;
    private static final LoadingCache<Executable, List<String>> PARAMETER_NAMES;

    private ReflectionHelper() {
    }

    public static boolean isArray(Type type) {
        return TypeToken.of((Type)type).getComponentType() != null;
    }

    public static boolean isOptional(Type type) {
        return TypeToken.of((Type)type).getRawType() == Optional.class;
    }

    public static Class<?> getArrayOfType(Type componentType) {
        Class rawComponentType = TypeToken.of((Type)componentType).getRawType();
        return Array.newInstance(rawComponentType, 0).getClass();
    }

    public static Type getMapKeyType(Type type) {
        return TypeToken.of((Type)type).resolveType(MAP_KEY_TYPE).getType();
    }

    public static Type getMapValueType(Type type) {
        return TypeToken.of((Type)type).resolveType(MAP_VALUE_TYPE).getType();
    }

    public static Type getIterableType(Type type) {
        return TypeToken.of((Type)type).resolveType(ITERATOR_TYPE).resolveType(ITERATOR_ELEMENT_TYPE).getType();
    }

    public static Type getOptionalType(Type type) {
        return TypeToken.of((Type)type).resolveType(OPTIONAL_TYPE).getType();
    }

    public static Type getFutureReturnType(Type type) {
        return TypeToken.of((Type)type).resolveType(FUTURE_RETURN_TYPE).getType();
    }

    public static <T extends Annotation> Set<T> getEffectiveClassAnnotations(Class<?> type, Class<T> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return ImmutableSet.of(type.getAnnotation(annotation));
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ReflectionHelper.addEffectiveClassAnnotations(type, annotation, builder);
        return builder.build();
    }

    private static <T extends Annotation> void addEffectiveClassAnnotations(Class<?> type, Class<T> annotation, ImmutableSet.Builder<T> builder) {
        if (type.isAnnotationPresent(annotation)) {
            builder.add(type.getAnnotation(annotation));
            return;
        }
        if (type.getSuperclass() != null) {
            ReflectionHelper.addEffectiveClassAnnotations(type.getSuperclass(), annotation, builder);
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            ReflectionHelper.addEffectiveClassAnnotations(anInterface, annotation, builder);
        }
    }

    public static Iterable<Method> getAllDeclaredMethods(Class<?> type) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Class<?> clazz = type; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            methods.addAll((Iterable)ImmutableList.copyOf((Object[])clazz.getDeclaredMethods()));
        }
        return methods.build();
    }

    public static Iterable<Field> getAllDeclaredFields(Class<?> type) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Class<?> clazz = type; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            fields.addAll((Iterable)ImmutableList.copyOf((Object[])clazz.getDeclaredFields()));
        }
        return fields.build();
    }

    public static Collection<Method> findAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers()) || (managedMethod = ReflectionHelper.findAnnotatedMethod(type, annotation, method.getName(), method.getParameterTypes())) == null) continue;
            result.add(managedMethod);
        }
        return result;
    }

    public static Method findAnnotatedMethod(Class<?> configClass, Class<? extends Annotation> annotation, String methodName, Class<?> ... paramTypes) {
        Method managedMethod;
        try {
            Method method = configClass.getDeclaredMethod(methodName, paramTypes);
            if (method != null && method.isAnnotationPresent(annotation)) {
                return method;
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (configClass.getSuperclass() != null && (managedMethod = ReflectionHelper.findAnnotatedMethod(configClass.getSuperclass(), annotation, methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : configClass.getInterfaces()) {
            Method managedMethod2 = ReflectionHelper.findAnnotatedMethod(iface, annotation, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }

    public static Collection<Field> findAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : type.getFields()) {
            if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation)) continue;
            result.add(field);
        }
        return result;
    }

    public static List<String> extractParameterNames(Executable methodOrConstructor) {
        return (List)PARAMETER_NAMES.getUnchecked((Object)methodOrConstructor);
    }

    private static List<String> getParameterNames(Executable executable) {
        Objects.requireNonNull(executable, "executable is null");
        if (executable.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        List parameterNamesFromThriftField = (List)Arrays.stream(executable.getParameters()).map(ReflectionHelper::getThriftFieldParameterName).collect(ImmutableList.toImmutableList());
        if (parameterNamesFromThriftField.stream().allMatch(Optional::isPresent)) {
            return (List)parameterNamesFromThriftField.stream().map(Optional::get).collect(ImmutableList.toImmutableList());
        }
        List parameterNamesFromClass = ParameterNames.getParameterNames((Executable)executable);
        ImmutableList.Builder parameterNames = ImmutableList.builder();
        for (int i = 0; i < parameterNamesFromThriftField.size(); ++i) {
            parameterNames.add(((Optional)parameterNamesFromThriftField.get(i)).orElse(parameterNamesFromClass.get(i)));
        }
        return parameterNames.build();
    }

    private static Optional<String> getThriftFieldParameterName(Parameter parameter) {
        return Optional.ofNullable(parameter.getAnnotation(ThriftField.class)).flatMap(thriftField -> Optional.ofNullable(Strings.emptyToNull((String)thriftField.name())));
    }

    public static String extractFieldName(Method method) {
        Objects.requireNonNull(method, "method is null");
        return ReflectionHelper.extractFieldName(method.getName());
    }

    public static String extractFieldName(String methodName) {
        Objects.requireNonNull(methodName, "methodName is null");
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return methodName;
    }

    public static Type resolveFieldType(Type structType, Type genericType) {
        return TypeToken.of((Type)structType).resolveType(genericType).getType();
    }

    public static Type[] resolveFieldTypes(Type structType, Type[] genericTypes) {
        return (Type[])Arrays.stream(genericTypes).map(type -> ReflectionHelper.resolveFieldType(structType, type)).toArray(Type[]::new);
    }

    static {
        try {
            Method mapPutMethod = Map.class.getMethod("put", Object.class, Object.class);
            MAP_KEY_TYPE = mapPutMethod.getGenericParameterTypes()[0];
            MAP_VALUE_TYPE = mapPutMethod.getGenericParameterTypes()[1];
            ITERATOR_TYPE = Iterable.class.getMethod("iterator", new Class[0]).getGenericReturnType();
            ITERATOR_ELEMENT_TYPE = Iterator.class.getMethod("next", new Class[0]).getGenericReturnType();
            OPTIONAL_TYPE = Optional.class.getMethod("get", new Class[0]).getGenericReturnType();
            Method futureGetMethod = Future.class.getMethod("get", new Class[0]);
            FUTURE_RETURN_TYPE = futureGetMethod.getGenericReturnType();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        PARAMETER_NAMES = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Executable, List<String>>(){

            public List<String> load(Executable executable) {
                return ReflectionHelper.getParameterNames(executable);
            }
        });
    }
}

