/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.airlift.drift.codec.ThriftProtocolType;
import io.airlift.drift.codec.metadata.DefaultThriftTypeReference;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import io.airlift.drift.codec.metadata.ThriftEnumMetadata;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftType {
    public static final ThriftType BOOL = new ThriftType(ThriftProtocolType.BOOL, Boolean.TYPE);
    public static final ThriftType BYTE = new ThriftType(ThriftProtocolType.BYTE, Byte.TYPE);
    public static final ThriftType DOUBLE = new ThriftType(ThriftProtocolType.DOUBLE, Double.TYPE);
    public static final ThriftType I16 = new ThriftType(ThriftProtocolType.I16, Short.TYPE);
    public static final ThriftType I32 = new ThriftType(ThriftProtocolType.I32, Integer.TYPE);
    public static final ThriftType I64 = new ThriftType(ThriftProtocolType.I64, Long.TYPE);
    public static final ThriftType STRING = new ThriftType(ThriftProtocolType.STRING, (Type)((Object)String.class));
    public static final ThriftType BINARY = new ThriftType(ThriftProtocolType.BINARY, (Type)((Object)ByteBuffer.class));
    public static final ThriftType VOID = new ThriftType(ThriftProtocolType.STRUCT, Void.TYPE);
    public static final ThriftTypeReference BOOL_REF = new DefaultThriftTypeReference(BOOL);
    public static final ThriftTypeReference BYTE_REF = new DefaultThriftTypeReference(BYTE);
    public static final ThriftTypeReference DOUBLE_REF = new DefaultThriftTypeReference(DOUBLE);
    public static final ThriftTypeReference I16_REF = new DefaultThriftTypeReference(I16);
    public static final ThriftTypeReference I32_REF = new DefaultThriftTypeReference(I32);
    public static final ThriftTypeReference I64_REF = new DefaultThriftTypeReference(I64);
    public static final ThriftTypeReference STRING_REF = new DefaultThriftTypeReference(STRING);
    public static final ThriftTypeReference BINARY_REF = new DefaultThriftTypeReference(BINARY);
    public static final ThriftTypeReference VOID_REF = new DefaultThriftTypeReference(VOID);
    private final ThriftProtocolType protocolType;
    private final Type javaType;
    private final ThriftTypeReference keyTypeReference;
    private final ThriftTypeReference valueTypeReference;
    private final ThriftStructMetadata structMetadata;
    private final ThriftEnumMetadata<?> enumMetadata;
    private final ThriftType uncoercedType;
    private final Object nullValue;

    public static ThriftType struct(ThriftStructMetadata structMetadata) {
        return new ThriftType(structMetadata);
    }

    public static <K, V> ThriftType map(ThriftType keyType, ThriftType valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        return ThriftType.map(new DefaultThriftTypeReference(keyType), new DefaultThriftTypeReference(valueType));
    }

    public static <K, V> ThriftType map(ThriftTypeReference keyTypeReference, ThriftTypeReference valueTypeReference) {
        Objects.requireNonNull(keyTypeReference, "keyTypeReference is null");
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        Type javaType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of((Type)keyTypeReference.getJavaType())).where(new TypeParameter<V>(){}, TypeToken.of((Type)valueTypeReference.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.MAP, javaType, keyTypeReference, valueTypeReference, null);
    }

    public static <E> ThriftType set(ThriftType valueType) {
        Objects.requireNonNull(valueType, "valueType is null");
        return ThriftType.set(new DefaultThriftTypeReference(valueType));
    }

    public static <E> ThriftType set(ThriftTypeReference valueTypeReference) {
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        Type javaType = new TypeToken<Set<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueTypeReference.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.SET, javaType, null, valueTypeReference, null);
    }

    public static <E> ThriftType list(ThriftType valueType) {
        Objects.requireNonNull(valueType, "valueType is null");
        return ThriftType.list(new DefaultThriftTypeReference(valueType));
    }

    public static <E> ThriftType list(ThriftTypeReference valueTypeReference) {
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        Type javaType = new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueTypeReference.getJavaType())).getType();
        return new ThriftType(ThriftProtocolType.LIST, javaType, null, valueTypeReference, null);
    }

    public static ThriftType array(ThriftType valueType) {
        Objects.requireNonNull(valueType, "valueType is null");
        return ThriftType.array(new DefaultThriftTypeReference(valueType));
    }

    public static ThriftType array(ThriftTypeReference valueTypeReference) {
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        Class<?> javaType = ReflectionHelper.getArrayOfType(valueTypeReference.getJavaType());
        return new ThriftType(ThriftProtocolType.LIST, javaType, null, valueTypeReference, null);
    }

    public static ThriftType optional(ThriftType valueType) {
        Objects.requireNonNull(valueType, "valueType is null");
        return ThriftType.optional(new DefaultThriftTypeReference(valueType));
    }

    public static <T> ThriftType optional(ThriftTypeReference valueTypeReference) {
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        Type javaType = new TypeToken<Optional<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of((Type)valueTypeReference.getJavaType())).getType();
        return new ThriftType(valueTypeReference.getProtocolType(), javaType, null, valueTypeReference, Optional.empty());
    }

    public static ThriftType enumType(ThriftEnumMetadata<?> enumMetadata) {
        Objects.requireNonNull(enumMetadata, "enumMetadata is null");
        return new ThriftType(enumMetadata);
    }

    private ThriftType(ThriftProtocolType protocolType, Type javaType) {
        Objects.requireNonNull(protocolType, "protocolType is null");
        Objects.requireNonNull(javaType, "javaType is null");
        this.protocolType = protocolType;
        this.javaType = javaType;
        this.keyTypeReference = null;
        this.valueTypeReference = null;
        this.structMetadata = null;
        this.enumMetadata = null;
        this.uncoercedType = null;
        this.nullValue = null;
    }

    private ThriftType(ThriftProtocolType protocolType, Type javaType, ThriftTypeReference keyTypeReference, ThriftTypeReference valueTypeReference, Object nullValue) {
        Objects.requireNonNull(protocolType, "protocolType is null");
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(valueTypeReference, "valueTypeReference is null");
        this.protocolType = protocolType;
        this.javaType = javaType;
        this.keyTypeReference = keyTypeReference;
        this.valueTypeReference = valueTypeReference;
        this.structMetadata = null;
        this.enumMetadata = null;
        this.uncoercedType = null;
        this.nullValue = nullValue;
    }

    private ThriftType(ThriftStructMetadata structMetadata) {
        Objects.requireNonNull(structMetadata, "structMetadata is null");
        this.protocolType = ThriftProtocolType.STRUCT;
        this.javaType = structMetadata.getStructType();
        this.keyTypeReference = null;
        this.valueTypeReference = null;
        this.structMetadata = structMetadata;
        this.enumMetadata = null;
        this.uncoercedType = null;
        this.nullValue = null;
    }

    private ThriftType(ThriftEnumMetadata<?> enumMetadata) {
        Objects.requireNonNull(enumMetadata, "enumMetadata is null");
        this.protocolType = ThriftProtocolType.ENUM;
        this.javaType = enumMetadata.getEnumClass();
        this.keyTypeReference = null;
        this.valueTypeReference = null;
        this.structMetadata = null;
        this.enumMetadata = enumMetadata;
        this.uncoercedType = null;
        this.nullValue = null;
    }

    public ThriftType(ThriftType uncoercedType, Type javaType) {
        this(uncoercedType, javaType, null);
    }

    public ThriftType(ThriftType uncoercedType, Type javaType, Object nullValue) {
        this.javaType = javaType;
        this.uncoercedType = uncoercedType;
        this.protocolType = uncoercedType.getProtocolType();
        this.keyTypeReference = null;
        this.valueTypeReference = null;
        this.structMetadata = null;
        this.enumMetadata = null;
        this.nullValue = nullValue;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public ThriftProtocolType getProtocolType() {
        return this.protocolType;
    }

    public ThriftTypeReference getKeyTypeReference() {
        Preconditions.checkState((this.keyTypeReference != null ? 1 : 0) != 0, (String)"%s does not have a key", (Object)((Object)this.protocolType));
        return this.keyTypeReference;
    }

    public ThriftTypeReference getValueTypeReference() {
        Preconditions.checkState((this.valueTypeReference != null ? 1 : 0) != 0, (String)"%s does not have a get", (Object)((Object)this.protocolType));
        return this.valueTypeReference;
    }

    public ThriftStructMetadata getStructMetadata() {
        Preconditions.checkState((this.structMetadata != null ? 1 : 0) != 0, (String)"%s does not have struct metadata", (Object)((Object)this.protocolType));
        return this.structMetadata;
    }

    public ThriftEnumMetadata<?> getEnumMetadata() {
        Preconditions.checkState((this.enumMetadata != null ? 1 : 0) != 0, (String)"%s does not have enum metadata", (Object)((Object)this.protocolType));
        return this.enumMetadata;
    }

    public boolean isCoerced() {
        return this.uncoercedType != null;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public ThriftType coerceTo(Type javaType) {
        if (javaType == this.javaType) {
            return this;
        }
        Preconditions.checkState((this.protocolType != ThriftProtocolType.STRUCT && this.protocolType != ThriftProtocolType.SET && this.protocolType != ThriftProtocolType.LIST && this.protocolType != ThriftProtocolType.MAP ? 1 : 0) != 0, (String)"Coercion is not supported for %s", (Object)((Object)this.protocolType));
        return new ThriftType(this, javaType);
    }

    public ThriftType getUncoercedType() {
        return this.uncoercedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftType that = (ThriftType)o;
        return this.protocolType == that.protocolType && Objects.equals(this.javaType, that.javaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.protocolType, this.javaType});
    }

    public String toString() {
        String structMetadataName = this.structMetadata != null ? this.structMetadata.getStructClass().getName() : null;
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("protocolType", (Object)this.protocolType).add("javaType", (Object)this.javaType).add("structMetadata", (Object)structMetadataName).add("keyTypeReference", (Object)this.keyTypeReference).add("valueTypeReference", (Object)this.valueTypeReference).toString();
    }
}

