/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.prestosql.plugin.thrift.ThriftIndexProvider;
import io.prestosql.plugin.thrift.ThriftMetadata;
import io.prestosql.plugin.thrift.ThriftPageSourceProvider;
import io.prestosql.plugin.thrift.ThriftSessionProperties;
import io.prestosql.plugin.thrift.ThriftSplitManager;
import io.prestosql.plugin.thrift.ThriftTransactionHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorIndexProvider;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftConnector
implements Connector {
    private static final Logger log = Logger.get(ThriftConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ThriftMetadata metadata;
    private final ThriftSplitManager splitManager;
    private final ThriftPageSourceProvider pageSourceProvider;
    private final ThriftSessionProperties sessionProperties;
    private final ThriftIndexProvider indexProvider;

    @Inject
    public ThriftConnector(LifeCycleManager lifeCycleManager, ThriftMetadata metadata, ThriftSplitManager splitManager, ThriftPageSourceProvider pageSourceProvider, ThriftSessionProperties sessionProperties, ThriftIndexProvider indexProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.indexProvider = Objects.requireNonNull(indexProvider, "indexProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return ThriftTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public ConnectorIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

