/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.drift.transport.netty.client.DriftNettyClientModule;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.thrift.ConnectorObjectNameGeneratorModule;
import io.prestosql.plugin.thrift.ThriftConnector;
import io.prestosql.plugin.thrift.ThriftHandleResolver;
import io.prestosql.plugin.thrift.ThriftModule;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class ThriftConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module locationModule;

    public ThriftConnectorFactory(String name, Module locationModule) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.locationModule = Objects.requireNonNull(locationModule, "locationModule is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ThriftHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new ConnectorObjectNameGeneratorModule(catalogName), new DriftNettyClientModule(), binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager()), this.locationModule, new ThriftModule()});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(ThriftConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

