/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import io.airlift.drift.client.DriftClient;
import io.prestosql.plugin.thrift.ThriftConnectorConfig;
import io.prestosql.plugin.thrift.ThriftConnectorIndex;
import io.prestosql.plugin.thrift.ThriftConnectorStats;
import io.prestosql.plugin.thrift.ThriftHeaderProvider;
import io.prestosql.plugin.thrift.ThriftIndexHandle;
import io.prestosql.plugin.thrift.api.PrestoThriftService;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorIndex;
import io.prestosql.spi.connector.ConnectorIndexHandle;
import io.prestosql.spi.connector.ConnectorIndexProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftIndexProvider
implements ConnectorIndexProvider {
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final long maxBytesPerResponse;
    private final int lookupRequestsConcurrency;
    private final ThriftConnectorStats stats;

    @Inject
    public ThriftIndexProvider(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, ThriftConnectorStats stats, ThriftConnectorConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(config, "config is null");
        this.maxBytesPerResponse = config.getMaxResponseSize().toBytes();
        this.lookupRequestsConcurrency = config.getLookupRequestsConcurrency();
    }

    public ConnectorIndex getIndex(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        return new ThriftConnectorIndex(this.client, this.thriftHeaderProvider.getHeaders(session), this.stats, (ThriftIndexHandle)indexHandle, lookupSchema, outputSchema, this.maxBytesPerResponse, this.lookupRequestsConcurrency);
    }
}

