/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.drift.TException;
import io.airlift.drift.client.DriftClient;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.thrift.ThriftColumnHandle;
import io.prestosql.plugin.thrift.ThriftErrorCode;
import io.prestosql.plugin.thrift.ThriftHeaderProvider;
import io.prestosql.plugin.thrift.ThriftIndexHandle;
import io.prestosql.plugin.thrift.ThriftTableHandle;
import io.prestosql.plugin.thrift.ThriftTableLayoutHandle;
import io.prestosql.plugin.thrift.ThriftTableMetadata;
import io.prestosql.plugin.thrift.annotations.ForMetadataRefresh;
import io.prestosql.plugin.thrift.api.PrestoThriftNullableSchemaName;
import io.prestosql.plugin.thrift.api.PrestoThriftNullableTableMetadata;
import io.prestosql.plugin.thrift.api.PrestoThriftSchemaTableName;
import io.prestosql.plugin.thrift.api.PrestoThriftService;
import io.prestosql.plugin.thrift.api.PrestoThriftServiceException;
import io.prestosql.plugin.thrift.util.ThriftExceptions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorIndexHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorResolvedIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ThriftMetadata
implements ConnectorMetadata {
    private static final Logger LOGGER = Logger.get(ThriftMetadata.class);
    private static final Duration EXPIRE_AFTER_WRITE = new Duration(10.0, TimeUnit.MINUTES);
    private static final Duration REFRESH_AFTER_WRITE = new Duration(2.0, TimeUnit.MINUTES);
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final TypeManager typeManager;
    private final LoadingCache<SchemaTableName, Optional<ThriftTableMetadata>> tableCache;

    @Inject
    public ThriftMetadata(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, TypeManager typeManager, @ForMetadataRefresh Executor metadataRefreshExecutor) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(EXPIRE_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS).refreshAfterWrite(REFRESH_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::getTableMetadataInternal), (Executor)metadataRefreshExecutor));
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        try {
            return ((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listSchemaNames();
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return ((Optional)this.tableCache.getUnchecked((Object)tableName)).map(ThriftTableMetadata::getSchemaTableName).map(ThriftTableHandle::new).orElse(null);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ThriftTableHandle tableHandle = (ThriftTableHandle)table;
        ThriftTableLayoutHandle layoutHandle = new ThriftTableLayoutHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), desiredColumns, (TupleDomain<ColumnHandle>)constraint.getSummary());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(new ConnectorTableLayout((ConnectorTableLayoutHandle)layoutHandle), constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ThriftTableHandle handle = (ThriftTableHandle)tableHandle;
        return this.getRequiredTableMetadata(new SchemaTableName(handle.getSchemaName(), handle.getTableName())).toConnectorTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        try {
            return (List)((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listTables(new PrestoThriftNullableSchemaName((String)schemaName.orElse(null))).stream().map(PrestoThriftSchemaTableName::toSchemaTableName).collect(ImmutableList.toImmutableList());
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return (Map)this.getTableMetadata(session, tableHandle).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ThriftColumnHandle::new));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((ThriftColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tableNames = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : tableNames) {
            try {
                columns.put((Object)tableName, this.getRequiredTableMetadata(tableName).getColumns());
            }
            catch (TableNotFoundException e) {
                LOGGER.error("get table error : %s", new Object[]{e.getMessage()});
            }
        }
        return columns.build();
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ThriftTableHandle table = (ThriftTableHandle)tableHandle;
        ThriftTableMetadata tableMetadata = this.getRequiredTableMetadata(new SchemaTableName(table.getSchemaName(), table.getTableName()));
        if (tableMetadata.containsIndexableColumns(indexableColumns)) {
            return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)new ThriftIndexHandle(tableMetadata.getSchemaTableName(), tupleDomain, session), tupleDomain));
        }
        return Optional.empty();
    }

    private ThriftTableMetadata getRequiredTableMetadata(SchemaTableName schemaTableName) {
        Optional table = (Optional)this.tableCache.getUnchecked((Object)schemaTableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(schemaTableName);
        }
        return (ThriftTableMetadata)table.get();
    }

    private Optional<ThriftTableMetadata> getTableMetadataInternal(SchemaTableName schemaTableName) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        PrestoThriftNullableTableMetadata thriftTableMetadata = this.getTableMetadata(schemaTableName);
        if (thriftTableMetadata.getTableMetadata() == null) {
            return Optional.empty();
        }
        ThriftTableMetadata tableMetadata = new ThriftTableMetadata(thriftTableMetadata.getTableMetadata(), this.typeManager);
        if (!Objects.equals(schemaTableName, tableMetadata.getSchemaTableName())) {
            throw new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_INVALID_RESPONSE, "Requested and actual table names are different");
        }
        return Optional.of(tableMetadata);
    }

    private PrestoThriftNullableTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        PrestoThriftSchemaTableName name;
        try {
            name = new PrestoThriftSchemaTableName(schemaTableName);
        }
        catch (IllegalArgumentException e) {
            return new PrestoThriftNullableTableMetadata(null);
        }
        try {
            return ((PrestoThriftService)this.client.get()).getTableMetadata(name);
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }
}

