/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.drift.client.ExceptionClassification;
import io.airlift.drift.client.guice.DriftClientBinder;
import io.prestosql.plugin.thrift.ThriftConnector;
import io.prestosql.plugin.thrift.ThriftConnectorConfig;
import io.prestosql.plugin.thrift.ThriftConnectorStats;
import io.prestosql.plugin.thrift.ThriftIndexProvider;
import io.prestosql.plugin.thrift.ThriftMetadata;
import io.prestosql.plugin.thrift.ThriftPageSourceProvider;
import io.prestosql.plugin.thrift.ThriftSessionProperties;
import io.prestosql.plugin.thrift.ThriftSplitManager;
import io.prestosql.plugin.thrift.annotations.ForMetadataRefresh;
import io.prestosql.plugin.thrift.api.PrestoThriftService;
import io.prestosql.plugin.thrift.api.PrestoThriftServiceException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftModule
implements Module {
    public void configure(Binder binder) {
        DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(PrestoThriftService.class).withExceptionClassifier(t -> {
            if (t instanceof PrestoThriftServiceException) {
                boolean retryable = ((PrestoThriftServiceException)t).isRetryable();
                return new ExceptionClassification(Optional.of(retryable), ExceptionClassification.HostStatus.NORMAL);
            }
            return ExceptionClassification.NORMAL_EXCEPTION;
        });
        binder.bind(ThriftConnector.class).in(Scopes.SINGLETON);
        binder.bind(ThriftMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ThriftSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ThriftPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftConnectorConfig.class);
        binder.bind(ThriftSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(ThriftIndexProvider.class).in(Scopes.SINGLETON);
        binder.bind(ThriftConnectorStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftConnectorStats.class).withGeneratedName();
    }

    @Provides
    @Singleton
    @ForMetadataRefresh
    public Executor createMetadataRefreshExecutor(ThriftConnectorConfig config) {
        return Executors.newFixedThreadPool(config.getMetadataRefreshThreads(), Threads.daemonThreadsNamed((String)"metadata-refresh-%s"));
    }
}

