/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import io.airlift.drift.client.DriftClient;
import io.prestosql.plugin.thrift.ThriftConnectorConfig;
import io.prestosql.plugin.thrift.ThriftConnectorSplit;
import io.prestosql.plugin.thrift.ThriftConnectorStats;
import io.prestosql.plugin.thrift.ThriftHeaderProvider;
import io.prestosql.plugin.thrift.ThriftPageSource;
import io.prestosql.plugin.thrift.api.PrestoThriftService;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftPageSourceProvider
implements ConnectorPageSourceProvider {
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final long maxBytesPerResponse;
    private final ThriftConnectorStats stats;

    @Inject
    public ThriftPageSourceProvider(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, ThriftConnectorStats stats, ThriftConnectorConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderFactor is null");
        this.maxBytesPerResponse = Objects.requireNonNull(config, "config is null").getMaxResponseSize().toBytes();
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
        return new ThriftPageSource(this.client, this.thriftHeaderProvider.getHeaders(session), (ThriftConnectorSplit)split, columns, this.stats, this.maxBytesPerResponse);
    }
}

