/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import io.prestosql.plugin.thrift.ThriftConnectorFactory;
import io.prestosql.plugin.thrift.ThriftPluginInfo;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.function.ConnectorConfig;
import io.prestosql.spi.queryeditorui.ConnectorUtil;
import io.prestosql.spi.queryeditorui.ConnectorWithProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

@ConnectorConfig(connectorLabel="Thrift : Connect to Thrift servers to integrate with external storage systems", propertiesEnabled=true, catalogConfigFilesEnabled=true, globalConfigFilesEnabled=true, docLink="https://openlookeng.io/docs/docs/connector/thrift.html", configLink="https://openlookeng.io/docs/docs/connector/thrift.html#configuration")
public class ThriftPlugin
implements Plugin {
    private final String name;
    private final Module module;

    public ThriftPlugin() {
        this(ThriftPlugin.getPluginInfo());
    }

    private ThriftPlugin(ThriftPluginInfo info) {
        this(info.getName(), info.getModule());
    }

    public ThriftPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new ThriftConnectorFactory(this.name, this.module));
    }

    private static ThriftPluginInfo getPluginInfo() {
        ClassLoader classLoader = ThriftPlugin.class.getClassLoader();
        ServiceLoader<ThriftPluginInfo> loader = ServiceLoader.load(ThriftPluginInfo.class, classLoader);
        ImmutableList list = ImmutableList.copyOf(loader);
        return list.isEmpty() ? new ThriftPluginInfo() : (ThriftPluginInfo)Iterables.getOnlyElement((Iterable)list);
    }

    public Optional<ConnectorWithProperties> getConnectorWithProperties() {
        ConnectorConfig connectorConfig = ThriftPlugin.class.getAnnotation(ConnectorConfig.class);
        Optional connectorWithProperties = ConnectorUtil.assembleConnectorProperties((ConnectorConfig)connectorConfig, (Iterable)ImmutableList.of());
        if (connectorWithProperties.isPresent()) {
            ConnectorWithProperties.Properties properties = new ConnectorWithProperties.Properties();
            properties.setName("presto.thrift.client.addresses");
            properties.setDescription("Location of Thrift servers");
            properties.setValue("host1:port,host2:port");
            properties.setRequired(Optional.of(true));
            properties.setReadOnly(Optional.of(false));
            properties.setType(Optional.of("string"));
            ((ConnectorWithProperties)connectorWithProperties.get()).addProperties(properties);
        }
        return connectorWithProperties;
    }
}

