/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.drift.client.DriftClient;
import io.prestosql.plugin.thrift.ThriftColumnHandle;
import io.prestosql.plugin.thrift.ThriftConnectorSplit;
import io.prestosql.plugin.thrift.ThriftHeaderProvider;
import io.prestosql.plugin.thrift.ThriftTableLayoutHandle;
import io.prestosql.plugin.thrift.api.PrestoThriftHostAddress;
import io.prestosql.plugin.thrift.api.PrestoThriftId;
import io.prestosql.plugin.thrift.api.PrestoThriftNullableColumnSet;
import io.prestosql.plugin.thrift.api.PrestoThriftNullableToken;
import io.prestosql.plugin.thrift.api.PrestoThriftSchemaTableName;
import io.prestosql.plugin.thrift.api.PrestoThriftService;
import io.prestosql.plugin.thrift.api.PrestoThriftSplit;
import io.prestosql.plugin.thrift.api.PrestoThriftTupleDomain;
import io.prestosql.plugin.thrift.util.ThriftExceptions;
import io.prestosql.plugin.thrift.util.TupleDomainConversion;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;

public class ThriftSplitManager
implements ConnectorSplitManager {
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;

    @Inject
    public ThriftSplitManager(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        ThriftTableLayoutHandle layoutHandle = (ThriftTableLayoutHandle)layout;
        return new ThriftSplitSource((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session)), new PrestoThriftSchemaTableName(layoutHandle.getSchemaName(), layoutHandle.getTableName()), layoutHandle.getColumns().map(ThriftSplitManager::columnNames), TupleDomainConversion.tupleDomainToThriftTupleDomain(layoutHandle.getConstraint()));
    }

    private static Set<String> columnNames(Set<ColumnHandle> columns) {
        return (Set)columns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
    }

    @NotThreadSafe
    private static class ThriftSplitSource
    implements ConnectorSplitSource {
        private final PrestoThriftService client;
        private final PrestoThriftSchemaTableName schemaTableName;
        private final Optional<Set<String>> columnNames;
        private final PrestoThriftTupleDomain constraint;
        private final AtomicBoolean hasMoreData;
        private final AtomicReference<PrestoThriftId> nextToken;
        private final AtomicReference<Future<?>> future;

        public ThriftSplitSource(PrestoThriftService client, PrestoThriftSchemaTableName schemaTableName, Optional<Set<String>> columnNames, PrestoThriftTupleDomain constraint) {
            this.client = Objects.requireNonNull(client, "client is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
            this.constraint = Objects.requireNonNull(constraint, "constraint is null");
            this.nextToken = new AtomicReference<Object>(null);
            this.hasMoreData = new AtomicBoolean(true);
            this.future = new AtomicReference<Object>(null);
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkState((this.future.get() == null || this.future.get().isDone() ? 1 : 0) != 0, (Object)"previous batch not completed");
            Preconditions.checkState((boolean)this.hasMoreData.get(), (Object)"this method cannot be invoked when there's no more data");
            PrestoThriftId currentToken = this.nextToken.get();
            ListenableFuture splitsFuture = this.client.getSplits(this.schemaTableName, new PrestoThriftNullableColumnSet((Set)this.columnNames.orElse(null)), this.constraint, maxSize, new PrestoThriftNullableToken(currentToken));
            ListenableFuture resultFuture = Futures.transform((ListenableFuture)splitsFuture, batch -> {
                Objects.requireNonNull(batch, "batch is null");
                List splits = (List)batch.getSplits().stream().map(ThriftSplitSource::toConnectorSplit).collect(ImmutableList.toImmutableList());
                Preconditions.checkState((boolean)this.nextToken.compareAndSet(currentToken, batch.getNextToken()));
                Preconditions.checkState((boolean)this.hasMoreData.compareAndSet(true, this.nextToken.get() != null));
                return new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished());
            }, (Executor)MoreExecutors.directExecutor());
            resultFuture = ThriftExceptions.catchingThriftException(resultFuture);
            this.future.set((Future<?>)resultFuture);
            return MoreFutures.toCompletableFuture(resultFuture);
        }

        public boolean isFinished() {
            return !this.hasMoreData.get();
        }

        public void close() {
            Future currentFuture = this.future.getAndSet(null);
            if (currentFuture != null) {
                currentFuture.cancel(true);
            }
        }

        private static ThriftConnectorSplit toConnectorSplit(PrestoThriftSplit thriftSplit) {
            return new ThriftConnectorSplit(thriftSplit.getSplitId(), ThriftSplitSource.toHostAddressList(thriftSplit.getHosts()));
        }

        private static List<HostAddress> toHostAddressList(List<PrestoThriftHostAddress> hosts) {
            return (List)hosts.stream().map(PrestoThriftHostAddress::toHostAddress).collect(ImmutableList.toImmutableList());
        }
    }
}

