/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;

public final class ThriftTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public ThriftTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public ThriftTableHandle(SchemaTableName schemaTableName) {
        this(schemaTableName.getSchemaName(), schemaTableName.getTableName());
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftTableHandle other = (ThriftTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

