/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.thrift.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.drift.TApplicationException;
import io.airlift.drift.TException;
import io.airlift.drift.protocol.TTransportException;
import io.prestosql.plugin.thrift.ThriftErrorCode;
import io.prestosql.plugin.thrift.api.PrestoThriftServiceException;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.concurrent.Executor;

public final class ThriftExceptions {
    private ThriftExceptions() {
    }

    public static PrestoException toPrestoException(Exception e) {
        if (e instanceof TTransportException && "No hosts available".equals(e.getMessage())) {
            throw new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_NO_AVAILABLE_HOSTS, (Throwable)e);
        }
        if (e instanceof TApplicationException || e instanceof PrestoThriftServiceException) {
            return new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_GENERIC_REMOTE_ERROR, "Exception raised by remote Thrift server: " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof TException) {
            return new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_CONNECTION_ERROR, "Error communicating with remote Thrift server", (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
    }

    public static <T> ListenableFuture<T> catchingThriftException(ListenableFuture<T> future) {
        return Futures.catchingAsync(future, Exception.class, e -> Futures.immediateFailedFuture((Throwable)ThriftExceptions.toPrestoException(e)), (Executor)MoreExecutors.directExecutor());
    }
}

