/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client;

import com.google.common.base.Ticker;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.drift.TException;
import io.airlift.drift.client.ExceptionClassification;
import io.airlift.drift.client.RetriesFailedException;
import io.airlift.drift.client.RetryPolicy;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.stats.MethodInvocationStat;
import io.airlift.drift.protocol.TTransportException;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.client.Address;
import io.airlift.drift.transport.client.ConnectionFailedException;
import io.airlift.drift.transport.client.DriftApplicationException;
import io.airlift.drift.transport.client.InvokeRequest;
import io.airlift.drift.transport.client.MethodInvoker;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class DriftMethodInvocation<A extends Address>
extends AbstractFuture<Object> {
    private static final Logger log = Logger.get(DriftMethodInvocation.class);
    private final MethodInvoker invoker;
    private final MethodMetadata metadata;
    private final Map<String, String> headers;
    private final List<Object> parameters;
    private final RetryPolicy retryPolicy;
    private final AddressSelector<A> addressSelector;
    private final Optional<String> addressSelectionContext;
    private final MethodInvocationStat stat;
    private final Ticker ticker;
    private final long startTime;
    @GuardedBy(value="this")
    private final Set<A> attemptedAddresses = new LinkedHashSet<A>();
    @GuardedBy(value="this")
    private final Multiset<A> failedConnectionAttempts = HashMultiset.create();
    @GuardedBy(value="this")
    private int failedConnections;
    @GuardedBy(value="this")
    private int overloadedRejects;
    @GuardedBy(value="this")
    private int invocationAttempts;
    @GuardedBy(value="this")
    private Throwable lastException;
    @GuardedBy(value="this")
    private ListenableFuture<?> currentTask;

    static <A extends Address> DriftMethodInvocation<A> createDriftMethodInvocation(MethodInvoker invoker, MethodMetadata metadata, Map<String, String> headers, List<Object> parameters, RetryPolicy retryPolicy, AddressSelector<A> addressSelector, Optional<String> addressSelectionContext, MethodInvocationStat stat, Ticker ticker) {
        DriftMethodInvocation<A> invocation = new DriftMethodInvocation<A>(invoker, metadata, headers, parameters, retryPolicy, addressSelector, addressSelectionContext, stat, ticker);
        super.nextAttempt(true);
        return invocation;
    }

    private DriftMethodInvocation(MethodInvoker invoker, MethodMetadata metadata, Map<String, String> headers, List<Object> parameters, RetryPolicy retryPolicy, AddressSelector<A> addressSelector, Optional<String> addressSelectionContext, MethodInvocationStat stat, Ticker ticker) {
        this.invoker = Objects.requireNonNull(invoker, "methodHandler is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        this.addressSelector = Objects.requireNonNull(addressSelector, "addressSelector is null");
        this.addressSelectionContext = Objects.requireNonNull(addressSelectionContext, "addressSelectionContext is null");
        this.stat = Objects.requireNonNull(stat, "stat is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.startTime = ticker.read();
        super.addListener(() -> {
            if (super.isCancelled()) {
                this.onCancel(this.wasInterrupted());
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void nextAttempt(boolean noConnectDelay) {
        try {
            if (this.isCancelled()) {
                return;
            }
            Optional<A> address = this.addressSelector.selectAddress(this.addressSelectionContext, this.attemptedAddresses);
            if (!address.isPresent()) {
                this.fail("No hosts available");
                return;
            }
            if (this.invocationAttempts > 0) {
                this.stat.recordRetry();
            }
            if (noConnectDelay) {
                this.invoke((Address)address.get());
                return;
            }
            int connectionFailuresCount = this.failedConnectionAttempts.count(address.get());
            if (connectionFailuresCount == 0) {
                this.invoke((Address)address.get());
                return;
            }
            Duration connectDelay = this.retryPolicy.getBackoffDelay(connectionFailuresCount);
            log.debug("Failed connection to %s with attempt %s, will retry in %s", new Object[]{address.get(), connectionFailuresCount, connectDelay});
            this.schedule(connectDelay, () -> this.invoke((Address)address.get()));
        }
        catch (Throwable t) {
            this.unexpectedError(t);
        }
    }

    private synchronized void invoke(final A address) {
        try {
            long invocationStartTime = this.ticker.read();
            ListenableFuture result = this.invoker.invoke(new InvokeRequest(this.metadata, address, this.headers, this.parameters));
            this.stat.recordResult(invocationStartTime, (ListenableFuture<Object>)result);
            this.currentTask = result;
            Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    DriftMethodInvocation.this.resetConnectionFailures(address);
                    DriftMethodInvocation.this.set(result);
                }

                public void onFailure(Throwable t) {
                    DriftMethodInvocation.this.handleFailure(address, t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            this.unexpectedError(t);
        }
    }

    private synchronized void resetConnectionFailures(A address) {
        this.failedConnectionAttempts.setCount(address, 0);
    }

    private synchronized void handleFailure(A address, Throwable throwable) {
        try {
            if (throwable instanceof ConnectionFailedException) {
                ++this.failedConnections;
            }
            ExceptionClassification exceptionClassification = this.retryPolicy.classifyException(throwable, this.metadata.isIdempotent());
            this.attemptedAddresses.add(address);
            if (exceptionClassification.getHostStatus() == ExceptionClassification.HostStatus.NORMAL) {
                this.lastException = throwable;
                ++this.invocationAttempts;
            } else if (exceptionClassification.getHostStatus() == ExceptionClassification.HostStatus.DOWN || exceptionClassification.getHostStatus() == ExceptionClassification.HostStatus.OVERLOADED) {
                this.addressSelector.markdown(address);
                this.failedConnectionAttempts.add(address);
                if (exceptionClassification.getHostStatus() == ExceptionClassification.HostStatus.OVERLOADED) {
                    ++this.overloadedRejects;
                }
            }
            Duration duration = Duration.succinctNanos((long)(this.ticker.read() - this.startTime));
            if (!exceptionClassification.isRetry().orElse(Boolean.FALSE).booleanValue()) {
                this.lastException = throwable;
                this.fail("Non-retryable exception");
                return;
            }
            if (this.invocationAttempts > this.retryPolicy.getMaxRetries()) {
                this.fail(String.format("Max retry attempts (%s) exceeded", this.retryPolicy.getMaxRetries()));
                return;
            }
            if (duration.compareTo(this.retryPolicy.getMaxRetryTime()) >= 0) {
                this.fail(String.format("Max retry time (%s) exceeded", this.retryPolicy.getMaxRetryTime()));
                return;
            }
            if (exceptionClassification.getHostStatus() != ExceptionClassification.HostStatus.NORMAL) {
                this.nextAttempt(false);
                return;
            }
            Duration backoffDelay = this.retryPolicy.getBackoffDelay(this.invocationAttempts);
            log.debug("Failed invocation of %s with attempt %s, will retry in %s (overloadedRejects: %s). Exception: %s", new Object[]{this.metadata.getName(), this.invocationAttempts, backoffDelay, this.overloadedRejects, throwable.getMessage()});
            this.schedule(backoffDelay, () -> this.nextAttempt(true));
        }
        catch (Throwable t) {
            this.unexpectedError(t);
        }
    }

    private synchronized void schedule(Duration timeout, final Runnable task) {
        try {
            ListenableFuture delay;
            this.currentTask = delay = this.invoker.delay(timeout);
            Futures.addCallback((ListenableFuture)delay, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    task.run();
                }

                public void onFailure(Throwable t) {
                    DriftMethodInvocation.this.unexpectedError(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            this.unexpectedError(t);
        }
    }

    private synchronized void onCancel(boolean wasInterrupted) {
        if (this.currentTask != null) {
            this.currentTask.cancel(wasInterrupted);
        }
    }

    private synchronized void fail(String reason) {
        Throwable cause = this.lastException;
        if (cause == null) {
            cause = new TTransportException(reason);
        }
        RetriesFailedException retriesFailedException = new RetriesFailedException(reason, this.invocationAttempts, Duration.succinctNanos((long)(this.ticker.read() - this.startTime)), this.failedConnections, this.overloadedRejects);
        if (cause instanceof DriftApplicationException) {
            cause.getCause().addSuppressed(retriesFailedException);
        } else {
            cause.addSuppressed(retriesFailedException);
        }
        this.setException(cause);
    }

    private synchronized void unexpectedError(Throwable throwable) {
        String message = "Unexpected error processing invocation of " + this.metadata.getName();
        this.setException((Throwable)new TException(message, throwable));
        log.error(throwable, message);
    }
}

