/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client.address;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.address.SimpleAddressSelectorConfig;
import io.airlift.drift.transport.client.Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class SimpleAddressSelector
implements AddressSelector<SimpleAddress> {
    private final Set<HostAndPort> addresses;
    private final boolean retrySameAddress;

    public SimpleAddressSelector(SimpleAddressSelectorConfig config) {
        this(config.getAddresses(), config.isRetrySameAddress());
    }

    public SimpleAddressSelector(Iterable<HostAndPort> addresses, boolean retrySameAddress) {
        for (HostAndPort address : addresses) {
            Preconditions.checkArgument((address.getPortOrDefault(0) > 0 ? 1 : 0) != 0, (Object)"address port must be set");
        }
        this.addresses = ImmutableSet.copyOf(addresses);
        this.retrySameAddress = retrySameAddress;
    }

    @VisibleForTesting
    Set<HostAndPort> getAddresses() {
        return this.addresses;
    }

    @Override
    @Deprecated
    public Optional<SimpleAddress> selectAddress(Optional<String> addressSelectionContext) {
        return this.selectAddress(addressSelectionContext, (Set<SimpleAddress>)ImmutableSet.of());
    }

    @Override
    public Optional<SimpleAddress> selectAddress(Optional<String> addressSelectionContext, Set<SimpleAddress> attempted) {
        Preconditions.checkArgument((!addressSelectionContext.isPresent() ? 1 : 0) != 0, (Object)"addressSelectionContext should not be set");
        Objects.requireNonNull(attempted, "attempted is null");
        ArrayList<SimpleAddress> result = new ArrayList<SimpleAddress>();
        for (HostAndPort address : this.addresses) {
            try {
                for (InetAddress ip : InetAddress.getAllByName(address.getHost())) {
                    SimpleAddress simpleAddress = new SimpleAddress(HostAndPort.fromParts((String)ip.getHostAddress(), (int)address.getPort()));
                    if (!this.retrySameAddress && attempted.contains(simpleAddress)) continue;
                    result.add(simpleAddress);
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        SimpleAddress address = (SimpleAddress)result.get(ThreadLocalRandom.current().nextInt(result.size()));
        return Optional.of(address);
    }

    @Override
    public void markdown(SimpleAddress address) {
    }

    public static final class SimpleAddress
    implements Address {
        private final HostAndPort hostAndPort;

        public SimpleAddress(HostAndPort hostAndPort) {
            this.hostAndPort = Objects.requireNonNull(hostAndPort, "hostAndPort is null");
        }

        public HostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleAddress that = (SimpleAddress)o;
            return Objects.equals(this.hostAndPort, that.hostAndPort);
        }

        public int hashCode() {
            return Objects.hash(this.hostAndPort);
        }

        public String toString() {
            return this.hostAndPort.toString();
        }
    }
}

